/*
 * Distributed V Kernel 
 * Copyright (c) 1982 by David Cheriton, Tim Mann, Willy Zwaenepoel
 *
 * Inter kernel communication routines
 * Minimal set needed for standalone bootstrap loader,
 *   hacked up to run in busy-wait mode (TPM 11/11/83)
 * Partly based on a similar hack done for SGI
 *
 */

#include "process.h"
#include "Vikc.h"
#include "Vethernet.h"
#include "Vioprotocol.h"

#define	MAXTRANS		10
#define MAX_PACKET_DELAY	100

/*************************************************************************
 *                                                                       *
 *            These definitions used to be in Venviron.h                 *
 *                                                                       *
 *************************************************************************/
/* Indexes in messages and masks used for segment definitions */
/* These will be removed soon. Do not use. */

#define OPCODE_INDEX		0
#define SEGMENTPTR_INDEX	6
#define SEGMENTSIZE_INDEX	7

#define IDEMPOTENT_MASK		0x20000000
#define SEGMENT_MASK		0x10000000
#define READ_MASK		0x08000000
#define WRITE_MASK		0x04000000
#define NO_REPLY_MASK		0x02000000
#define MANY_REPLY_MASK		0x01000000
/*************************************************************************/

#ifdef DEBUG
#define debug(c) K_putchar(c)
#else
#define debug(c)
#endif DEBUG

extern Process *Active;

unsigned short 	CurrentSeqNo = 1;
extern kPacket	*kPacketSave;
extern SystemCode AwaitKernelPacket();
int PacketDelay;  /* number of packets not for us received since last
		   *   good packet in AwaitSendReply */

#define CopyMsg(to, from) CopyBytes(to, from, 32)


/* For sending the boot requests (CreateInstance and Read) to the
 *   storage server, we need Send().  This is really a modified
 *   NonLocalSend() since the local case is not needed. */
Process_id Send ( msg, pid ) 
    register Unspec *msg; 
    Process_id pid;
  {
    register Process *pd, *prev;
    unsigned append;
    int WriteKernelPacket();
    SystemCode r;
    long *msgarray;

#ifdef DEBUG
printf("Send to %x: %x,%x,%x,%x,%x,%x,%x,%x\n", pid,
	msg[0], msg[1], msg[2], msg[3], msg[4], msg[5], msg[6], msg[7]);
#endif DEBUG
    /* Adjust process state */
    pd = Active;
    CopyMsg(pd->msg, msg);

    /* Check if there is segment associated with this message */
    msgarray = (long *) (pd->msg);
    if ( msgarray[OPCODE_INDEX] & SEGMENT_MASK )
      {
        pd->dataSegmentPro = 
		(unsigned char)((msgarray[OPCODE_INDEX]&0xff000000)>>24);
        pd->dataSegmentPtr = (Unspec *) (msgarray[SEGMENTPTR_INDEX]);
        pd->dataExpected = NULL;
        pd->dataSegmentSize = msgarray[SEGMENTSIZE_INDEX];
      }
    else
        pd->dataSegmentSize = 0;

    pd->forwarder = ( Process * ) pd->pid;
    pd->blocked_on = pid;
    pd->seqNo = CurrentSeqNo++;
    pd->state = AWAITING_REPLY;
    /* Send off packet */
    pd->numTrans = 0;
    while ( ++(pd->numTrans) < MAXTRANS )
      {
        if( (pd->dataSegmentPro & READ_ACCESS) &&
	    (pd->dataSegmentSize > 0 ) )
          {
	    if( pd->dataSegmentSize >= MAX_APPENDED_SEGMENT )
	        append = MAX_APPENDED_SEGMENT;
	    else
	        append = pd->dataSegmentSize;
	    WriteKernelPacket(remoteSend,pd->pid,pid,0,append,0,
		     	 NULL,pd->seqNo,msg,pd->dataSegmentPtr);
          }
        else
	    WriteKernelPacket(remoteSend,pd->pid,pid,0,0,NULL,
			 NULL,pd->seqNo,msg,NULL);
	if ( AwaitSendReply() == OK ) break;  /* got a reply */
debug('*');
      }
    if (pd->numTrans == MAXTRANS)
	*(short *) msg = TIMEOUT;  	/* timed out */
    else
	CopyMsg(msg, pd->msg);		/* succeeded */

#ifdef DEBUG
printf("Reply from %x: %x,%x,%x,%x,%x,%x,%x,%x\n", pid,
	msg[0], msg[1], msg[2], msg[3], msg[4], msg[5], msg[6], msg[7]);
#endif DEBUG
    return (pd->blocked_on);
  }


  
AwaitSendReply()
    /*
     * Busy wait, looking for a reply to a Send.
     * Also handle MoveTo/MoveFrom requests while waiting.
     */
  {
    extern kPacket *kPacketSave;
    ProcessId pRemoteReply();
    ProcessId pBreathOfLife();
    ProcessId pRemoteMoveFromReq();
    ProcessId pRemoteMoveToReq();
    ProcessId pRemoteReceiveSpecific();

debug('O');
    PacketDelay = 0;
    for (;;)
      {
debug('P');
	if (AwaitKernelPacket() != OK) return (TIMEOUT);
debug('Q');

        switch (kPacketSave->packetType)
	  {
	  case remoteReply:
debug('R');
	    pRemoteReply();
	    if (Active->state == READY) return (OK);
debug('^');
	    break;

	  case breathOfLife:
debug('S');
	     pBreathOfLife();
	     break;

	  case remoteMoveFromReq:
debug('T');
	    pRemoteMoveFromReq();
	    break;

	  case remoteMoveToReq: 
debug('U');
	    pRemoteMoveToReq();
	    break;

	  case remoteReceiveSpecific:
debug('W');
	    pRemoteReceiveSpecific();
	    break;

	  default:
debug('V');
	    break;
	  }
        if( PacketDelay++ > MAX_PACKET_DELAY ) 
          {
debug('&');
	    return( TIMEOUT );
	  }
      }
  }




/* To pick up the server's replies */
Process_id pRemoteReply()
  {
    register Process *sender;
    register kPacket *kp = kPacketSave;

    sender = Active;

    if ( sender->pid != kp->dstPid ||
         sender->blocked_on != kp->srcPid ||
         sender->seqNo != kp->sequenceNo )
      return;
    sender->state = READY;
    CopyMsg( sender->msg, &kp->msg );
    if( kp->length != 0 )
      {
	if( ((sender->dataSegmentPro & WRITE_ACCESS) == 0 ) ||
	    ((unsigned)sender->dataSegmentPtr > (unsigned)kp->remoteaddress)||
	    ((unsigned)kp->remoteaddress+kp->length >
	     (unsigned)sender->dataSegmentPtr+sender->dataSegmentSize) )
	  {
	    DiscardDataPacket( kp->length );
	  }
	else
	  {
	    ReadDataPacket( kp->length, kp->remoteaddress );  
	  }
      }
    return;
  }


/* Server might send this */
Process_id pBreathOfLife()
  {
    register kPacket *kp = kPacketSave;
    register Process *sender;

    sender = Active;
    if ( sender->pid != kp->dstPid ||
	 sender->seqNo != kp->sequenceNo )
      return;
    sender->numTrans = 0;
    PacketDelay = 0;
  }

 

/* In case server does a ValidPid.  This style of ValidPid is
 *   still used by the V server, but not by the kernel, which
 *   uses QueryProcessState.  We don't handle the latter. */
ProcessId pRemoteReceiveSpecific()
  {
    register kPacket *kp = kPacketSave;

    if ( kp->dstPid == Active->pid )
      {
        WriteKernelPacket ( breathOfLife,kp->dstPid,kp->srcPid,0,0,NULL, 
			NULL,kp->sequenceNo,NULL,NULL );
      }
  }


/* In case the server needs to retrieve a filename */
Process_id pRemoteMoveFromReq()
  {
    Process *pd, *active;
    register kPacket *kp = kPacketSave;
    int WriteKernelPacket();
    int lengthLeft;

    pd = Active;
    if ( (pd->pid != kp->dstPid) ||
         (pd->state != AWAITING_REPLY) ||
         (pd->blocked_on != kp->srcPid) ||
	 ((pd->dataSegmentPro & READ_ACCESS) == 0) ||
         ((unsigned)pd->dataSegmentPtr > (unsigned)kp->remoteaddress) ||
         ((unsigned)kp->remoteaddress+kp->length > 
	  (unsigned)(pd->dataSegmentPtr)+pd->dataSegmentSize) ) 
      {
        return;
      }

    pd->numTrans = 0;	/* Reset transmissions counter */
    PacketDelay = 0;
    lengthLeft = kp->length;
    while (lengthLeft > MAX_APPENDED_SEGMENT)
      {
        WriteKernelPacket(remoteMoveFromReply,kp->dstPid,kp->srcPid,
		  0,MAX_APPENDED_SEGMENT,kp->length,
		  kp->localaddress,kp->sequenceNo,NULL,kp->remoteaddress);
        kp->localaddress = (Unspec *)((unsigned)(kp->localaddress) 
		+ MAX_APPENDED_SEGMENT);
        kp->remoteaddress = (Unspec *)((unsigned)(kp->remoteaddress) 
		+ MAX_APPENDED_SEGMENT);
	lengthLeft -= MAX_APPENDED_SEGMENT;
      }
    if( lengthLeft != 0 )
      {
        WriteKernelPacket(remoteMoveFromReply,kp->dstPid,kp->srcPid,
		  0, lengthLeft,kp->length,
		  kp->localaddress,kp->sequenceNo,NULL,kp->remoteaddress);
      }
  }
   

/* This allows the server to load stuff into our memory */
Process_id pRemoteMoveToReq()
  {
    Process *pd, *active;
    register kPacket *kp = kPacketSave;
    int ReadDataPacket(), DiscardDataPacket();
    /* kp->remoteaddress is a local address,
       kp->localaddress is the total length */

    pd = active = Active;
    if ( (pd->pid != kp->dstPid) ||
	 (pd->state != AWAITING_REPLY) ||
         (pd->blocked_on != kp->srcPid) ||
	 ((pd->dataSegmentPro & WRITE_ACCESS) == 0) ||
	 (kp->remoteaddress < pd->dataSegmentPtr) ||
         ((unsigned)kp->remoteaddress+kp->length > 
	  (unsigned)(pd->dataSegmentPtr)+pd->dataSegmentSize) )
      {
debug('@');
        DiscardDataPacket( kp->length );
        return;
      }

    pd->numTrans = 0; /* Reset transmission counter */
    PacketDelay = 0;

    /* Sequencing check */
    if( pd->dataExpected == NULL ||		/* new MoveTo group */
	kp->sequenceNo != pd->seqNoExpected ||
        kp->remoteaddress < pd->remoteSegmentPtr )
      {
debug('p');
	pd->seqNoExpected = kp->sequenceNo;
        pd->remoteSegmentPtr = pd->dataExpected = kp->remoteaddress;
        pd->remoteSegmentSize = (unsigned) kp->localaddress;
      }

    if( kp->remoteaddress == pd->dataExpected )
      {
debug('r');
        pd->dataExpected = (Unspec *)((unsigned)pd->dataExpected+kp->length);
        ReadDataPacket( kp->length, kp->remoteaddress );

        /* Check if done */
        if((unsigned)pd->dataExpected ==
	   (unsigned)pd->remoteSegmentPtr + pd->remoteSegmentSize)
	  {
	    pd->dataExpected = NULL;
	    WriteKernelPacket(remoteMoveToReply,kp->dstPid,kp->srcPid,
			      0,pd->remoteSegmentSize,pd->remoteSegmentPtr,
			      NULL,kp->sequenceNo,NULL,NULL);
  	  }
      }
    else
      {
debug('s');
        DiscardDataPacket( kp->length );
      }
  }


/* Stuff related to naming */

ProcessId GetPid ( logical_id, scope ) register unsigned logical_id;

  {
    register Process *pd;
    int WriteKernelPacket();
    ProcessId pid;

    pd = Active;
    pd->blocked_on = logical_id; /* Preserved here for retransmission */
    pd->seqNo = CurrentSeqNo++;
    pd->state = GETPID_BLKED;
    pd->numTrans = 0;

    while ( ++(pd->numTrans) < MAXTRANS )
      {
        /* The destination pid in WriteKernelPacket has to be zero to make
           pretty damn sure that the packet is broadcast! */
        WriteKernelPacket(remoteGetPid,pd->pid,0,logical_id,0,NULL,
		      NULL,pd->seqNo,NULL,NULL);
	if ( AwaitGetPidReply(pd->seqNo, 0, pd->pid, logical_id) )
	    return ( pd->blocked_on );  /* Returned process id goes here */
      }
    return (0);
  }


AwaitGetPidReply(seqno, srcpid, dstpid, logical_id)
    unsigned short seqno;
    ProcessId srcpid, dstpid;
    unsigned logical_id;
  {
    register Process *sender;
    extern EnetBlock *EnetPacket;

    PacketDelay = 0;
    sender = Active;
    for (;;)
      {
	if (AwaitKernelPacket() != OK) return (0);
	if (kPacketSave->packetType == remoteGetPidReply &&
            kPacketSave->dstPid == sender->pid &&
	    kPacketSave->forwarder == logical_id &&
	    kPacketSave->sequenceNo == sender->seqNo) break;
	if ( PacketDelay++ > MAX_PACKET_DELAY ) return (0);
      }
    return (sender->blocked_on = kPacketSave->srcPid);
  }

#ifdef undef
/* This is to be installed when the V server 
 * (not just the xV server) understands groups.
 */

ProcessId GetPid ( logical_id, scope )
register unsigned logical_id;
  {
    MsgStruct msg;

    msg.sysCode = GET_PID;
    msg.pid = 0;
    msg.unspecified[0] = logical_id;
    msg.unspecified[1] = scope;
    Send(&msg, VKERNEL_SERVER_GROUP);
    return(msg.pid);
  }
#endif undef


