/*
 * sunromvec.h	
 *
 * From SMI version 2.4 dated 10/08/82, transcribed from SMI manual
 * Copyright (c) 1982 by Sun Microsystems Inc.
 */
struct sunromvec
  {
    char *v_initsp;		/* Initial SSP for hardware RESET */
    int (*v_startmon)();	/* Initial PC for hardware RESET */
/* Monitor and hardware revision and identification */
    char *v_SunRev;		/* Revision level of monitor & hardware */
    long *v_SerialNum;		/* Serial number of this Sun */
    long *v_MemorySize;		/* Physical onboard memory size */
/* Monitor-managed single-character input and output */
    unsigned char (*v_getchar)();	/* Get char from cur input source */
    int (*v_putchar)();		/* Put char to current output sink */
    int (*v_mayget)();		/* Maybe get char from cur input source */
    int (*v_mayput)();		/* Maybe put char to current output sink */
    unsigned char *v_EchoOn;	/* Should getchar echo its input? */
    unsigned char *v_InSource;	/* Input source selector */
    unsigned char *v_OutSink;	/* Output sink selector */
/* Monitor-managed keyboard input (scanned by memory refresh routine) */
    int (*v_getkey)();		/* Get next translated key if one exists */
    int (*v_InitGetkey)();	/* Initialize before first getkey */
    unsigned int *v_translation;	/* Keyboard translation selector */
    unsigned char *v_KeybId;	/* Up/down keyboard ID byte */
#ifdef KEYBOARD_STRUCTS
    struct keyboard **v_CurKeyboard;	/* Addr curr keyboard defn struct */
    struct keymap *(**v_SetTable)();	/* Addr curr shift->table mapper */
    struct keybuf *v_Keybuf;	/* Up/down keycode buffer */
#else
    char *foo1, *foo2, *foo3;	/* filler */
#endif KEYBOARD_STRUCTS
/* Monitor-managed framebuffer output and terminal emulation */
    int (*v_finit)();		/* Framebuffer initialization routine */
    int (*v_fwritechar)();	/* Write a character to FB "terminal" */
    long *v_FBAddr;		/* Address of frame buffer we are using */
    char **v_FontTable;		/* Address of font table for FB "terminal" */
    int (*v_fwrstr)();		/* Write string to FB--faster [than what?] */
/* Monitor-managed mouse input (scanned by monitor refresh routine) */
    int *v_MouseBuf;		/* Placeholder for mouse input buffer */
/* Monitor-managed line input and parsing */
    unsigned char *v_linbuf;	/* The line input buffer */
    unsigned char **v_lineptr;	/* Current pointer into linbuf */
    int *v_linesize;		/* Total length of line in linbuf */
    int (*v_getline)();		/* Fill linbuf from curr input source */
    unsigned char (*v_getone)();	/* Get next char from linbuf */
    unsigned char (*v_peekchar)();	/* Peek at next char w/o reading it */
    int (*v_gethexbyte)();	/* Get next 2 chars and xlate hex->binary */
    int (*v_getnum)();		/* Get next 2 numerics & xlate dec->binary */
/* Monitor-managed phrase output to current output sink */
    int (*v_message)();		/* Print a null-terminated string */
    int (*v_printhex)();	/* Print N digits of a longword in hex */
/* Memory management routines which must run outside mappable address space */
    int (*v_SetSeg)();		/* Set segment map entry X in context C */
    short (*v_GetSeg)();	/* Get segment map entry X from context C */
/* Refresh-related information */
    int (*v_KeyFrsh)();		/* Address that oughta be in level 7 vector */
    int (*AbortEnt)();		/* Monitor entry point from keyboard abort */
    int *v_RefrCnt;		/* Refresh routine's millisecond count */
/* Assorted useful things added after the first bunch */
    char *(*v_bedecode)();	/* Bus error decoding routine */
    int (**v_keyentry)();	/* Called when table has unknown entry */
/* Monitor internal interface information */
#ifdef GLOBRAM_STRUCT
    struct globram *v_GlobPtr;	/* Addr of monitor global variables */
#else
    char *foo4;
#endif GLOBRAM_STRUCT
    int (*v_diagret)();		/* Reentry point for diagnostics (see below)*/
/* Assorted other things added for Rev D */
    int *v_KRptInitial;		/* ms to wait before repeating held key */
    unsigned char *v_KRptTick;	/* ms to wait between repetitions */
    char ***v_KStrTab;		/* Ptr to table of string gen'd by keys */
    int (*v_pos)();		/* Cursor positioner for terminal emulator */
    int (*v_blinkscreen)();	/* Screen blinker (bell) for term emulator */
    int (*v_ExitOp)();		/* Exits from user program to Monitor */
  };

/* Allocation for RomVecPtr is defined in the rawio library,
 * where it is initialized to SUN1_ROM_VEC_PTR.
 * If we are compiling the kernel for a sun2, the value of RomVecPtr is changed
 * to SUN2_ROM_VEC_PTR so that the prom is mapped to the proper location.
 * This is done in the Init_memory_mapping routine of sun2mem.c.
 */
extern struct sunromvec *RomVecPtr;
#define SUN1_ROM_VEC_PTR	0x200000
#define SUN2_ROM_VEC_PTR	0xEF0000

/* Values for v_InSource and v_OutSink */
#define InKEYB		0	/* Input from parallel keyboard */
#define OutSCREEN	0	/* Output to frame buffer */
#define IoUARTA		1	/* Input or output to Uart A */
#define IoUARTB		2	/* Input or output to Uart B */

/***********end***************/
