/*
 * Distributed V Kernel 
 * Copyright (c) 1982 by David Cheriton, Tim Mann, Willy Zwaenepoel
 *
 * Standalone Ethernet driver (for Excelan board).
 *   Ross Finlayson, April 17, 1984
 */

#include "process.h"
#include "Vethernet.h"
#include "Vikc.h"
#include "xlnconsts.h"


#define CopyMsg(to, from) CopyBytes(to, from, 32)

/* Exports */
extern SystemCode EnetPowerup();
extern SystemCode AwaitKernelPacket();
extern int WriteKernelPacket();
int KernelPacketType = V_KERNEL_PACKET;
char HexEnetAddress[sizeof(NetAddress)*2 + 1];

NetAddress	EnetHostNumber;		/* physical ethernet address */

#define		EnetPacket	( (EnetBlock *) ReadDataBuf )
kPacket *kPacketSave = (kPacket *) EnetPacket->data;

NetAddress	ServerHostAddress;	/* A one-address "cache" */
int		ServerLogicalHost = -1;

NetAddress	BroadcastAddress = { 0xFFFF, 0xFFFF, 0xFFFF };


static clear(ptr, n)
    register char *ptr;
    register n;
  {
    while (n-- > 0)
        *ptr++ = 0;
  }


static InterruptBoard()
  {
    register counter = 10000;

    while ((PORTB & X_NOT_READY) && (--counter > 0))
        ; /* Wait until it's OK to write to PORTB. */
    PORTB = 0;			/* Interrupt the board by writing to PORTB. */
  }


int SetMode( newmode )
	unsigned newmode;
  {
    /*
     * Set the mode of the interface.
     */
    register struct ModeMsg *modemsg, *replymsg;
    register counter;

    modemsg = (struct ModeMsg *) MsgQPtr->hreqtail;
    modemsg->request = NET_MODE;
    modemsg->reqmask = WRITEREQ;
    modemsg->mode = newmode;
    modemsg->errmask = AlignmentError+CRCError;
    modemsg->status = EXOS_OWNER|HOST_DONE;
    InterruptBoard();

    replymsg = (struct ModeMsg *) MsgQPtr->hrephdr;
    counter = 100000;
    while (replymsg->status != HOST_OWNER|EXOS_DONE)
        if (--counter == 0)
	    return(0);
    replymsg->status = EXOS_OWNER | HOST_DONE;
    InterruptBoard();
    return(1);
  }


int enopen()
 {
    /*
     *  Powerup and initialize the Ethernet Interface Board. 0 is returned if
     *  the board couldn't be initialized.
     */
    register i;
    long addr;
    register struct testp *testpat;
    /* The following variables are replaced by constants. */
/*  struct MsgBuf *reqbufptr, *repbufptr;
    struct Init *configmsg;*/

    /* Reset board, by reading from PORTA. If PORTA cannot be read (eg. because
     * there's no Excelan board at all), then ProbeAddress will return 0).
     */
    if (!ProbeAddress((&PORTA)&~1)) /* NB: ProbeAddress tries to read a short*/
        return (0); /* No board? */

    i = 0;
    while( ( PORTB & X_ERROR ) == 0 )	/* Test status--wait for response. */
      if( i++ > 100000 )
	  return(0); /* Ethernet interface didn't reset. */

    /* Set up Multibus Memory-the shared memory between board and processor.*/
    clear( MsgQVirAddr, sizeof( struct MsgQs ) );

    /* Initialize message queues. */
    MsgQPtr->xreqhdr = HostToExAddr( MsgQPtr->requestbufs );
    MsgQPtr->xreptail = HostToExAddr( MsgQPtr->replybufs );
    MsgQPtr->hreqtail = MsgQPtr->requestbufs;
    MsgQPtr->hrephdr = MsgQPtr->replybufs;

    /* Initialize (the single) request buffer--Host to Exos buffer. */
#define reqbufptr ( MsgQPtr->requestbufs )
	reqbufptr->next = reqbufptr;
	reqbufptr->msg.link = HostToExAddr( reqbufptr );
	reqbufptr->msg.length = MSGLEN;
	reqbufptr->msg.status = HOST_OWNER | EXOS_DONE;

    /* Initialize (the single) reply buffer--Exos to Host buffer. */
#define	repbufptr ( MsgQPtr->replybufs )
	repbufptr->next = repbufptr;
	repbufptr->msg.link = HostToExAddr( repbufptr );
	repbufptr->msg.length = MSGLEN;
	repbufptr->msg.status = EXOS_OWNER | HOST_DONE;

    /* Construct configuration message. */

#define configmsg ( (struct Init *)ReadDataBuf )/* Beginning of buffer space. */
    clear( configmsg, sizeof *configmsg );	/* Defaults all values to 0. */

    configmsg->res0 = 1;			/* Excelan doc: pgs. 24-5. */
    configmsg->code = 0xff;
    configmsg->mode = 0;			/* Link level cntrlr mode. */
    configmsg->format[0] = 1;			/* Look at test pattern. */
    configmsg->format[1] = 1;
    testpat = (struct testp *)configmsg->mmap;
    testpat->b0 = 1;
    testpat->b1 = 3;
    testpat->b2 = 7;
    testpat->b3 = 0xf;
    testpat->w0 = 0x103;
    testpat->w1 = 0x70f;
    testpat->l0 = 0x103070f;
    configmsg->amode = 3;			/* Absolute address mode. */
    configmsg->mvblk = -1L;			/* 0xffffffff  */
    configmsg->nproc = 0xff;
    configmsg->nmbox = 0xff;
    configmsg->naddr = 0xff;
    configmsg->nhost = 1;
    configmsg->hxitype = 0;			/* no Interrupts. */
    configmsg->xhitype = 0;
    configmsg->hxseg = VirToPhys( MsgQVirSegAddr );
				/* Request Q offsets calculated from here. */
    configmsg->xhseg = VirToPhys( MsgQVirSegAddr );
				/* Reply Q offsets calculated from here. */
    configmsg->hxhead = ( (int) &MsgQPtr->xreqhdr - MsgQVirSegAddr );
    configmsg->xhhead = ( (int) &MsgQPtr->xreptail - MsgQVirSegAddr );

    addr = 0x0000ffff;
    for( i = 0; i < 4; i++ )
      {
	while( PORTB & X_NOT_READY );		/* Wait for device ready. */
	PORTB = addr & 0xff;
	addr >>= 8;
      }

    /* Now send physical address of configmsg. */

    addr = VirToPhys( configmsg );
    for( i = 0; i < 4; i++ )
      {
	while( PORTB & X_NOT_READY );		/* Wait for device ready. */
	PORTB = addr & 0xff;
	addr >>= 8;
      }

    /* Wait for Exos to change code. */
    i = 100000;
    while( configmsg->code == 0xff )
	if (--i == 0)
	    return (0); /* Board didn't configure. */

    return (SetMode( CONNECT_TO_NET ));
  }



enetaddress(enetAddr)
    char *enetAddr;
    /* returns our Ethernet address in "enetAddr". */
  {
    register struct AddrsMsg *addrmsg, *replymsg;
    register counter;
    register char *src;

    addrmsg = (struct AddrsMsg *) MsgQPtr->hreqtail;
    addrmsg->request = NET_ADDRS;
    addrmsg->reqmask = READREQ;
    addrmsg->slot = PHYS_ADDRS_SLOT;
    addrmsg->status = EXOS_OWNER|HOST_DONE;
    InterruptBoard();

    replymsg = (struct AddrsMsg *) MsgQPtr->hrephdr;
    counter = 100000;
    while (replymsg->status != HOST_OWNER|EXOS_DONE)
        if (--counter == 0)
	    return;
	
    src = (char *) &( replymsg->addr );
    for( counter = 0; counter < sizeof( NetAddress ); counter++ )
	*enetAddr++ = *src++;
    replymsg->status = EXOS_OWNER | HOST_DONE;
    InterruptBoard();
  }


mc68kenread(timeout)
      long *timeout; /* Read timeout, in (very roughly) 1/100s units. */
   /*
    * Read a packet from the ethernet interface. 
    * We copy the packet from Multibus memory into the indicated buffer,
    */
  {
    register struct ReadMsg *readmsg, *replymsg;
    register long counter;
    
    /* Construct and send a read request--allowing reception of any packets
     * which might come in.
     */
    readmsg = (struct ReadMsg *) MsgQPtr->hreqtail;
    readmsg->request = NET_READ;
    readmsg->nblocks = 1;
    readmsg->block[0].len = sizeof(EnetBlock);
    readmsg->block[0].addr = VirToPhys( ReadDataBuf );
    readmsg->status = EXOS_OWNER | HOST_DONE;
    InterruptBoard();
 
    /* Wait for the board to reply. */
    replymsg = (struct ReadMsg *)MsgQPtr->hrephdr;
    counter = (*timeout) << 9; /* ie. * 512 */
    while (--counter > 0)
        if (replymsg->status == HOST_OWNER|EXOS_DONE)
	    break;
    *timeout = counter >> 9; /* ie. / 512 */
    replymsg->status = EXOS_OWNER | HOST_DONE;
    InterruptBoard();
  }


mc68kenwrite(count)
    int count; /* number of bytes to write. */
  {
    register struct XmitMsg *xmitmsg, *replymsg;
    register counter;
    
    /* Set up the request message. */
    xmitmsg = (struct XmitMsg *) MsgQPtr->hreqtail;
    xmitmsg->request = NET_XMIT;
    xmitmsg->nblocks = 1;
    xmitmsg->block[0].len = count;
    xmitmsg->block[0].addr = (long) VirToPhys( WriteDataBuf );
    xmitmsg->status = EXOS_OWNER|HOST_DONE;
    InterruptBoard();

    replymsg = (struct XmitMsg *) MsgQPtr->hrephdr;
    counter = 100000;
    while (replymsg->status != HOST_OWNER|EXOS_DONE)
        if (--counter == 0)
	    return(0);
    replymsg->status = EXOS_OWNER | HOST_DONE;
    InterruptBoard();
    return(1);
  }

ProcessId GetFakePid()
  /* Make up a process ID to use for the loader.
   * Also initializes the Ethernet address. */
  {
    extern Process *Active;
    register int i;
    register char *p, *q;

    enetaddress(&EnetHostNumber);

    /* Convert to hex for use elsewhere */
    p = (char *) &EnetHostNumber;
    q = HexEnetAddress;
    for (i=0; i<sizeof(EnetHostNumber); i++)
      {
	*q++ = MakeHexDigit((*p)>>4);
        *q++ = MakeHexDigit(*p++);
      }
    *q = '\0';

    return ( Active->pid = ((K_ticks()<<16) + 0xbead) & ~LITTLE_ENDIAN_HOST );
  }


SystemCode EnetPowerup()

  /*  Powerup and initialize the Ethernet Interface Board.
   */
  {
    enopen();

    GetFakePid(); /* Set network address as a side-effect */

    return( OK );
 }


SystemCode AwaitKernelPacket()

   /* Wait until a valid kernel packet is received.  Return
    *   TIMEOUT if we time out before getting one.
    */
  {
    int timeoutCount = 3000;

    /* loop until we receive a well-formed ethernet packet of type
     * "etherType", or until we timeout. */
    while (TRUE)  
    {
        /* (Attempt to) read an ethernet packet. */
	mc68kenread(&timeoutCount);
	if (timeoutCount <= 0)
	    return(TIMEOUT);

	/* Reject packets that don't have the ethertype that we want. */
	if (EnetPacket->EtherType != KernelPacketType)
	    continue;

	/* We have a good packet - return. */
	ServerHostAddress = EnetPacket->SrcHost;    
	if (DifferentIKCByteOrder(kPacketSave))
	  {
	    SwapIKPacket(kPacketSave);
	  }
	kPacketSave->packetType &= ~IKC_LITTLE_ENDIAN;
	ServerLogicalHost = (kPacketSave->srcPid)>>16;
	return (OK);
      }
  }


int WriteKernelPacket(type, srcPid, dstPid, forwarder, length,
		      localaddress, remoteaddress,sequenceNo, msg, data)	

/* Writes kernel packet to the Ethernet */

  short		type;
  ProcessId	srcPid, dstPid, forwarder;
  unsigned	length;
  Unspec	*localaddress;
  Unspec	*remoteaddress;
  unsigned short	sequenceNo;
  long		*msg;
  unsigned char *data;
  {
    register EnetBlock *enetpacket;
    register kPacket *packet;
    register unsigned bytes;
    register int dstLogicalHost;

    if (data != NULL)
	bytes = (length + 1) & ~1;
    else
	bytes = 0;

    enetpacket = (EnetBlock *) WriteDataBuf;

    dstLogicalHost = dstPid>>16;
    if (dstLogicalHost == ServerLogicalHost)
        enetpacket->DestHost = ServerHostAddress;
    else
        enetpacket->DestHost = BroadcastAddress;

    enetpacket->SrcHost = EnetHostNumber;
    enetpacket->EtherType = KernelPacketType;
    packet = (kPacket *) enetpacket->data;
    packet->packetType = type & ~IKC_LITTLE_ENDIAN;
    packet->sequenceNo = sequenceNo;
    packet->srcPid = srcPid;
    packet->dstPid = dstPid;
    packet->forwarder = forwarder;
    packet->userNumber = 0;		/* user number */
    packet->length = length;
    packet->localaddress = localaddress;
    packet->remoteaddress = remoteaddress;
    if( msg != NULL )
      {
	CopyMsg(&(packet->msg), msg);
      }
    if( data != NULL )
	CopyBytes( ((kPacketWithSegment *)packet)->data, data, length );

transmit:	
    mc68kenwrite(sizeof(kPacket) + 14 + bytes);
    return (OK);
  }

int ReadDataPacket ( bytes, dst )
    unsigned bytes; 
    unsigned char *dst;
  {
    CopyBytes( dst, ((kPacketWithSegment *)kPacketSave)->data, bytes );
    return( OK );
  }

int DiscardDataPacket ( bytes ) unsigned bytes;
  {
    return( OK );
  }
