/*
 * Xerox Network System (XNS) definitions
 *
 * Bill Nowicki September 1983
 * 
 * Taken from Bill Yeager's xns.h 
 */

# ifdef ENET10MEG
# define XNS 0x600		/* 10Mbit Ethernet type for XNS */
# else ENET10MEG
# define XNS 03000		/* Experimental Ethernet type for XNS */
# endif ENET10MEG		/* (Note: These happen to be the same) */

# define SG_DIAG 	0x8013	/* SGI special kludges */
# define SG_GAMES 	0x8014
# define SG_BOUNCE 	0x8016


struct EnetHost
  {
  	/*
	 * a 48-bit Ethernet host address
	 */
      short addr[3];
  };

struct XNSpacket
  {
  	short checksum;
	short length;
	unsigned char transport, type;
	long destNet;
	struct EnetHost destHost;
	short destSocket;
	long sourceNet;
	struct EnetHost sourceHost;
	short sourceSocket;
	short data[1];
  };

/*
 * Well-known XNS sockets
 */
# define RoutingSocket 01
# define EchoSocket 02
# define RoutingErrorSocket 03
# define PupLookupSocket 011

/*
 * Well-known XNS Packet Types
 */
# define RoutingType 01
# define EchoType 02
# define ErrorType 03
# define PIType 04
# define SPPType 05
# define PupLookupType   06

/*
 * definitions for some of the opcode fields
 */
# define XipRequest  1
# define XipResponse 2
# define XipError    3
# define RoutingRequest  1
# define RoutingResponse 2
# define EchoRequest  1
# define EchoResponse 2


/* 
 * Definitions for the XNS To Pup and Pup To XNS translation
 * protocols. Note that NSToPup is for 3Mbit nets, and PupToNS
 * is for use on 10Mbit nets.
 */
# define NSToPup 03001	/* 48 bit -->  8 bit  (3Mbit wire) */
# define PupToNS 0x201	/*  8 bit --> 48 bit (10Mbit wire) */

# define HtRequest 010101
# define HtReply 07070

struct HtPacket
  { 
    unsigned short operation;	/* one of Request or Reply */ 
    struct EnetHost  desiredXNS;
    unsigned char desiredPUP;
    unsigned char space;
    struct EnetHost sendersXNS;
    unsigned char sendersPUP;
    char blank1;
  };

