/*
 * This file (ip.h) contains definitions of constants and data types
 * specific to the US DOD Arpa Internet Protocol
 */

typedef	unsigned int	IpHost;

#define ClassANet(n)	(n & 0x80000000)
#define IPNet(n)	(n & 0xff000000)N
#define Subnet(n)	(n & 0x00ff0000)

#define SuNet		0x24000000
#define LocalNet	0x00280000
#define MjhSumexSubgateway	0x77

/*
 * II. The following are definitions relevant to the downward interface of 
 * the IP layer.  That is, definitions of the transport types known to IP,
 * the packet type of IP for those transport mechanisms, and a table of the
 * currently active transport layer processes (and fucntions
 *
 */

# ifdef ENET10MEG
# define IP		0x800	/* ethertype of an IP packet */
# define ARP_TYPE	0x806	/* Address Resolution Protocol */
# else ENET10MEG
# define IP		01001	/* experimental ethertype of an IP packet */
# define ARP		01006	/* Address Resolution Protocol */
# endif ENET10MEG

# define RARP	0x8035	/* Reverse Address Resolution Protocol */

/*===========================================================================
 *     Following defines the IP packet data type
 *=========================================================================*/

#define	Fragment	0x3fff	/* mask frag flag, and  frag. offset	*/
#define	FragOffset	0x1fff	/* mask the fragment offset		*/
#define FragDF		0x4000	/* mask the "Don't Fragment" bit	*/
#define FragMF		0x2000	/* mask the "More Fragments" bit	*/
#define HDR_LENGTH	0xf	/* mask the ihl part of version-ihl	*/
#define Version		0xf0	/* mask the version part of version-ihl	*/
#define CurrentInternetVersion	4	/* Version we know about */
#define NormalHeaderLength 5 		/* length of IP header (longs) */

typedef
struct iphdr
  {
	char	VersionIhl;	/* 16 + header_length in longs		*/
	char	SvcType;	/* 0 (no abnormal service)		*/
	short	length;		/* packet length in bytes <= 576	*/
	unsigned short	id;	/* 0 (no fragments)			*/
	short	FlagsFragOffset;/* 0 (no fragments)			*/
	char	TimeToLive;	/* origin: 15; decrement on receipt	*/
	char	protocol;	/* type of data 			*/
	unsigned short	checksum;/* ~(1's cmp. sum of shorts in header)	*/
	int	source;
	int	dest;
  }
    *IpHdrPtr;

#define IAC   255             /* Interpret as command: */
#define DONT  254             /* You are not to use option */
#define DO    253             /* Please, you use option */
#define WONT  252             /* I won't use option */
#define WILL  251             /* I will use option */
#define SB    250             /* Interpret as subnegotiation */
#define GA    249             /* You may reverse the line */
#define EL    248             /* Erase the current line */
#define EC    247             /* Erase the current character */
#define AYT   246             /* Are you there */
#define AO    245             /* abort output--but let prog finish */
#define INT   244             /* interrupt process--permanently */
#define BREAK 243             /* Break */
#define DM    242             /* Data mark--for connect. cleaning */
#define NOP   241             /* Nop */
#define SE    240             /* End sub negotiation */

#define SYNCH 242	    /* For telfunc calls */

/* Telnet Options */

#define OPT_BINARY       0               /* Transmit binary */
#define OPT_ECHO         1               /* Echo */
#define OPT_RECONNECT	 2		 /* Reconnect */
#define OPT_SUPPRESS_GA  3               /* Suppress go ahead */
#define OPT_RECSIZE	 4		 /* Approximate message size */
#define OPT_STATUS       5               /* Status */
#define OPT_TMARK        6               /* Timing mark */
#define OPT_RCTE         7               /* RCTE */
#define OPT_LINEWIDTH    8               /* Output line width */
#define OPT_PAGESIZE     9               /* Output size */
#define OPT_CR_DISP      10              /* Output <cr> disposition */
#define OPT_HT_SET       11              /* Horizontal tab stops */
#define OPT_HT_DISP      12              /* Horizontal tap disposition */
#define OPT_FF_DISP      13              /* Output Formfeed Disposition */
#define OPT_VT_SET       14              /* Nego. about Vertical Tabstops */
#define OPT_VT_DISP      15              /* Nego. about Output V. T. Disp. */
#define OPT_LF_DISP      16              /* Nego. Output L.f. Disp. */
#define OPT_XASCII       17              /* Extended ascii option */
#define OPT_VTERM	 32		 /* Special VTSS option */

#   define SB_VTSWITCH	 1
#   define SB_MODES	 2

