#include <stdio.h>
#include "chaos.h"
/*
 * chaosprint.c - Decode CHAOS net datagrams
 *
 * Bill Yeager February 1986
 *
 * Copyright (c) 1986 Stanford University
 */
extern PrintData;
CHAOSPrint(buf,out,count)
  char *buf;
  FILE *out;
  int count;
  {
    register i,
	     j,
	     ndataBytes;
    register CHAOSLEV1 *c= (CHAOSLEV1 *)buf;
    register unsigned char *cp;

    ndataBytes = printChaosPacket(buf,out);
    j = (ndataBytes+CHAOSLEV1LEN+1) >> 1;
    if (count>>1 != j)
        fprintf(out,"\nLength inconsistency: Should be %d, is %d(shorts)",
	j, count);

    cp = &c->data[0];
    if (c->opcode == CHAOSRUT)
      {
	printRUT(cp,ndataBytes/RUTENTRYLEN);
	return;
      }

    fprintf(out,"\nData: ");
    for (i=0; i<ndataBytes && (i < 64 || PrintData); ++i)
      {
	PrettyPutchar(cp[i],out); 
      }
    if (i < ndataBytes) fprintf(out,"...");
    fprintf(out,"\n");
  }


printChaosPacket(c,out)
  register CHAOSLEV1 *c;
  FILE *out;
  {
    register unsigned short hops,
	     len,
	     tmp;
    
    tmp = c->hops4Length12;
    hops = LOADSHORT(tmp);
    len = hops & 0xFFF;
    hops >>= 12;
    fprintf(out,"Chaos   opcode %s res %d hops %d len %d bytes",
		ChaosOpcodeToString(c->opcode),
		c->reserved,hops,len);
    fprintf(out,"\n %d.%d(%o#%o#)|%d ==> %d.%d(%o#%o#)|%d",
		c->snet,c->shost, c->snet,c->shost,LOADSHORT(c->sindex),
		c->dnet,c->dhost, c->dnet,c->dhost,LOADSHORT(c->dindex));
   fprintf(out,"\n id %d ack %d",LOADSHORT(c->paknum),LOADSHORT(c->ack));
   return(len);
  }


ChaosOpcodeToString(opcode)
  int opcode;
  {
    switch (opcode)
      {
	case CHAOSRFC: return((int)"RFC");
	case CHAOSANS: return((int)"ANS");
	case CHAOSRUT: return((int)"RUT");
	case CHAOSBRD: return((int)"BRD");
	default: return((int)"UNKNOWN");
      }
  }


printRUT(re,imax)
  register RUTENTRY *re;
  register imax;
  {
    register i;
    register unsigned short subnet,cost;

    printf("\nData:  subnet cost  subnet cost  subnet cost\n");
    for (i=0; i<imax; ++i,++re) {
	    subnet = LOADSHORT(re->subnet);
	    cost = LOADSHORT(re->cost);
	    if ((i & 3) == 0) printf("\n      ");
	    printf("%6o %4o  ",subnet,cost);
      }
  }
