/*
 * sunwatch.c - Netwatch support funtions for SUN-family workstations
 *		(Including what used to be common.c)
 * 
 * Copyright (c) 1985 Stanford University
 *
 * Bill Nowicki January 1985
 */

#include <Vio.h>

GetMemSize()
  {
/*
 * Return the memory size for stack set-up; quite environment dependent!
 */
    return( K_getmemsize() );
  }


Ticks()
  {
/*
 * This function returns the current time (number of milliseconds) 
 *
 */
    return( K_ticks());
  }


int HitFlag = 0;		/* true if a key was ever hit */

KeyHit()
  {
	/*
	 * return true if a key was hit, handling
	 * both SMI suns and serial line interfaces
	 */
    int c = K_mayget();

    if (HitFlag) return(1);
    if (c != -1) 
      {
        if (c == ('s' & 037) )
	  {	
	  	/* 
		 * control S- wait for another character
		 */
	    getchar();
	    return(0);
	  }
        return(++HitFlag);
      }
    return(0);
  }


