
/* Routines to read and write function-code-3 space */

/* All routines assume that both function code registers contain "3"
 *   already.  The EPROM monitor is known to initialize them to that
 *   value, and the kernel never changes them.  */
asm("	.text			");
asm("	.globl Fc3ReadBit8	");
asm("Fc3ReadBit8:		");
asm("   movl sp@(4),a0		");	/* get arg into a0 */
asm("	movsb a0@, d0		");	/* move from outer space */
asm("	rts			");

#ifdef undef
asm("	.text			");
asm("	.globl Fc3ReadBit16	");
asm("Fc3ReadBit16:		");
asm("   movl sp@(4),a0		");	/* get arg into a0 */
asm("	movsw a0@, d0		");	/* move from outer space */
asm("	rts			");
#endif

asm("	.text			");
asm("	.globl Fc3ReadBit32	");
asm("Fc3ReadBit32:		");
asm("   movl sp@(4),a0		");	/* get arg into a0 */
asm("	movsl a0@,d0		");	/* move from outer space */
asm("	rts			");

#ifdef undef
asm("	.text			");
asm("	.globl Fc3WriteBit8	");
asm("Fc3WriteBit8:		");
asm("	movl sp@(4),a0		");	/* get address into a0 */
asm("	movl sp@(8),d0		");	/* get value into d0 */
asm("	movsb d0,a0@		");	/* move to outer space */
asm("	rts			");
#endif

#ifdef undef
asm("	.text			");
asm("	.globl Fc3WriteBit16	");
asm("Fc3WriteBit16:		");
asm("	movl sp@(4),a0		");	/* get address into a0 */
asm("	movl sp@(8),d0		");	/* get value into d0 */
asm("	movsw d0,a0@		");	/* move to outer space */
asm("	rts			");
#endif

asm("	.text			");
asm("	.globl Fc3WriteBit32	");
asm("Fc3WriteBit32:		");
asm("	movl sp@(4),a0		");	/* get address into a0 */
asm("	movl sp@(8),d0		");	/* get value into d0 */
asm("	movsl d0,a0@		");	/* move to outer space */
asm("	rts			");
