
#include "../../include/process.h"
#include <Vikc.h>
#include "sun2mem.h"
#include <Vethernet.h>
#include "enet50.h"

#define RECEIVE_BUFFERS 200

#ifdef DEBUG
#define debug(c) K_putchar(c)
#else
#define debug(c)
#endif

#define CopyMsg(to, from) Copy(to, from, sizeof(MsgStruct))
#define Offset(addr) ((unsigned short)(((long)(addr))-((long)&(cbs.scb))))
/*#define Address(offset) ((char *) (((long)offset) + (long)&(cbs.scb)))*/

extern unsigned short swap1();
extern swabSmall();
int ReceiverNotReady;

struct SystemConfigurationPointer *local_scp;
struct ISystemConfigurationPointer local_iscp;

/* Control Block Segment */
static struct ControlBlockSegment
  {
    struct SystemControlBlock scb;
    struct IAsetupblock IAsetupBlock;
    struct TransmitBufferDescriptor tbd;
    struct ReceiveFrameDescriptor rfa[RECEIVE_BUFFERS];
    struct ReceiveBufferDescriptor rbd[RECEIVE_BUFFERS];
    struct Configureblock cb;
  } cbs;

char local_rbuf[RECEIVE_BUFFERS][ENET_MAX_DATA+sizeof(Enet10Header)];

Enet10Address EnetHostNumber;
int LastStatus;
static struct ReceiveFrameDescriptor *IncomingFrame, *NextFrame, *LastFrame;

extern int IntOccured;

asm("    .text");
asm("    .globl nAsm_EnetInterrupt");
asm("    nAsm_EnetInterrupt:");
asm("    orw	#/0700,sr");
asm("	 moveml	#/c0c0,sp@-");		/* Save d0,d1,a0,a1 */
asm("    jbsr	nEnetInterrupt");
asm("    andw	#/F2FF,sr");
asm("	 orw	#/0200,sr");
asm("	 moveml	sp@+,#/0303");		/* Restore registers */
asm("	 rte");				/* Return */

nEnetInterrupt()
  {
    register struct SystemControlBlock *c = &cbs.scb;
    register int LastStatus;
    register short *ptr, i;
    register int buf;
    
    LastStatus = swap1(c->status);
    if (LastStatus & RNR) ReceiverNotReady = 1;
    if (LastStatus & FR)
      {
	if ((ReceiverNotReady == 0) && (++IncomingFrame == LastFrame))
	    IncomingFrame = cbs.rfa;
      }
    c->command = c->status & sACK_MASK; /* Acknowledge */
    c->CBLoffset = 0xFFFF; /* palindrome - no need to swap this */
    Attention();
    IntOccured = 2;
  }

InitEnetRead()
  {
    register int i;
    register struct ControlBlockSegment *c = &cbs;
    register struct ReceiveFrameDescriptor *f = c->rfa;
    register struct ReceiveBufferDescriptor *r = c->rbd;

    K_putchar('#');
    
    IncomingFrame = NextFrame = &cbs.rfa[0];
    c->scb.command = RUC_START;
    c->scb.RFAoffset = Offset(f);
    c->scb.CBLoffset = 0xffff;
    swabSmall(&(c->scb), sizeof(struct SystemControlBlock));

    for(i = 0; i < RECEIVE_BUFFERS; i++, f++, r++)
      {
	if (i == 0)
	  {
	    f->buffer = Offset(r);
	    (f+(RECEIVE_BUFFERS-1))->link = Offset(f); /* circular lists */
	    (r+(RECEIVE_BUFFERS-1))->next = Offset(r);
	  }
	else
	    f->buffer = 0xffff;
	f->command = 0;
	r->count = 0;
	r->size = ENET_MAX_DATA + sizeof( Enet10Header );
	r->bufferlow = LOW(local_rbuf[i]);
	r->bufferhigh = HIGH(local_rbuf[i]);

	if (i == RECEIVE_BUFFERS-1)
	  {
	    f->command = 0x8000; /* end of list */
	    r->size |= 0x8000;
	  }
        else
	  {
	    f->link = Offset(f+1);
	    r->next = Offset(r+1);
	  }
	swabSmall(f, sizeof(struct ReceiveFrameDescriptor));
	swabSmall(r, sizeof(struct ReceiveBufferDescriptor));
      }
    Attention();
    ReceiverNotReady = 0;
  }

InitMemory()
  {
    PageMapEntry newpage;
    
    /* Allocate the page that the 82586 uses for initialization
     */
    newpage.u = GetPageMap(0xB6000);
    SetPageMap(0xFFFFF6, newpage.u);    
    
    /* Change the pagemap entry for the prom to point to the
     * correct physical address.
     */
    newpage.u = GetPageMap(0xEF0000);
    SetPageMap(0x200000, newpage.u);
  }

EtherInit(address)
register short *address;
  {
    register short *addr = (short *) &EnetHostNumber;
    InitMemory();
    InitChip();
    InitEnetRead();
    *address++ = *addr++;
    *address++ = *addr++;
    *address++ = *addr++;
  }
    
InitChip()
  {
    register char *p;
    char *q;
    register long i;
    
    extern int nAsm_EnetInterrupt();
    register struct ControlBlockSegment *cbsr = &cbs;
    register struct IAsetupblock *IAblock = &(cbs.IAsetupBlock);
    register struct SystemControlBlock *c = &cbs.scb;
    struct Configureblock *cbp = &cbs.cb;

    LastFrame = &(cbs.rfa[RECEIVE_BUFFERS]);
    
    *((int(**)()) 0x06C) = nAsm_EnetInterrupt;
    asm("andw #/F2FF,sr");
    asm("orw #/0200,sr");

    p = (char *) &EnetHostNumber;
    for (i = 0x1008; i < 0x4008; i += 0x800)
	*p++ = Fc3ReadBit8(i);

    /* power up the ethernet chip */
    local_scp = (struct SystemConfigurationPointer *) SCPADDR;
    local_scp->sysbus = 0;
    local_scp->ISCPlow = LOW(&local_iscp);
    local_scp->ISCPhigh = HIGH(&local_iscp);
    swabSmall(local_scp, sizeof(struct SystemConfigurationPointer));

    local_iscp.busy = 1;
    local_iscp.SCBoffset = 0;
    local_iscp.SCBlow = LOW(c);
    local_iscp.SCBhigh = HIGH(c);
    swabSmall(&local_iscp, sizeof(struct ISystemConfigurationPointer));

    c->command = 0;
    *(unsigned char *)ENETREG = 0;
    IntOccured = 0;
    Attention();
    while (IntOccured == 0);

    c->command = CUC_START;
    c->CBLoffset = Offset(cbp);
    swabSmall(c, sizeof(struct SystemControlBlock));
    cbsr->cb.status = 0;
    cbsr->cb.command = swap1(CONFIGURE + COM_EL + COM_INTERRUPT);
    cbsr->cb.link = 0xffff;
    cbsr->cb.c[0] = 0x080C;
    cbsr->cb.c[1] = 0x2E80;
    cbsr->cb.c[2] = 0x6000;
    cbsr->cb.c[3] = 0xf200;
    cbsr->cb.c[4] = 0x0001;
    cbsr->cb.c[5] = 0x0040;
    IntOccured = 0;
    Attention();
    while( IntOccured == 0);

    c->command = CUC_START;
    c->CBLoffset = Offset(IAblock);
    swabSmall(c, sizeof(struct SystemControlBlock));
    IAblock->command = sIACOMMAND;
    IAblock->link = 0xffff;
    IAblock->address = EnetHostNumber; /* don't swap the host # */
    Attention();
  }

int EtherReady()
  {
    return( IncomingFrame != NextFrame );
  }

char *EtherPeek()
  {
    return( local_rbuf[NextFrame - cbs.rfa] - 2 );
  };

EtherRead(bufptr)
register unsigned short *bufptr;
  {
    register unsigned long buf;
    register unsigned short count;

    if (NextFrame != IncomingFrame)
      {
	buf = NextFrame - cbs.rfa;
	count = (swap1(cbs.rbd[buf].count) & 0x3fff);
	*bufptr++ = cbs.rfa[buf].status;
	*bufptr++ = count;
	Copy(bufptr, (&local_rbuf[buf][0]) - 2, count);
	EtherDrop();
      }
   }

EtherDrop()
  {
    register int buf, prev;

    buf = NextFrame - &cbs.rfa[0];
    prev = buf - 1;
    if (prev < 0) prev = RECEIVE_BUFFERS - 1;
    
    NextFrame->status = 0;
    NextFrame->buffer = 0xffff;
    NextFrame->command = 0x0080;
    cbs.rbd[buf].size |= 0x0080;
    cbs.rfa[prev].command = 0;
    cbs.rbd[prev].size &= 0xFF7f;
    if (++NextFrame == LastFrame) NextFrame = &cbs.rfa[0];
    if ((NextFrame == IncomingFrame) && (ReceiverNotReady == 1))
      {
	InitChip();
	InitEnetRead();
      }
  }

EnetSetFilter() {};
EnetNormalFilter() {};

char *EtherKind()
  {
    return("Sun 50");
  }

char statusbuf[128];
char *PrintEtherStatus(status)
register unsigned short status;
  {
    status = swap1(status);
    statusbuf[0] = 0;
    if (status & 0x0800) strcat(statusbuf, "CRC error ");
    if (status & 0x0400) strcat(statusbuf, "Alignment error ");
    if (status & 0x0200) strcat(statusbuf, "Resources error ");
    if (status & 0x0100) strcat(statusbuf, "DMA overrun ");
    if (status & 0x0800) strcat(statusbuf, "Packet too small ");
    if (status & 0x0400) strcat(statusbuf, "No EOF ");
    return(statusbuf);
  }

EtherBadStatus(status)
register unsigned short status;
  {
    return( (!status & 0x0020) ); /* swapped 0x2000 ( OK ) */
  }
