/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 * Open
 *
 * Stripped down for Vload
 */

#include "Vioprotocol.h"

extern File *_Open();	/* forward declaration */

File *Open( pathname, mode, error ) char *pathname; short mode;
					SystemCode *error;

  /* Open the file indicated by the string pathname
   * with the specified mode.
   * FREAD - reading.
   * FCREATE - create a new instance for writing.
   * FAPPEND - append
   * FMODIFY
   * FBLOCK_MODE - do not allocate a buffer.
   */
  {
    Message msg;
    register CreateInstanceRequest *request = (CreateInstanceRequest *) msg;
    ProcessId server;
    register File *fad;
    register CreateInstanceReply *reply = (CreateInstanceReply *) request;
    IoRequest *ioreq = (IoRequest *) request;
    unsigned localtype;

    request->requestcode = CREATE_INSTANCE;
    request->filename = pathname;
    request->filenamelen = 100;	/* Assume null-terminated */
    request->filenameindex = 0; /* Use the entire pathname */

    /* Direct to local name server if context specified,
     *  else to current file server */
    server = DirectToCurrentContext(request);

    *error = OK;

    localtype = mode & (FBLOCK_MODE|FRELEASE_ON_CLOSE);
    mode &= ~localtype; /* Strip off local type bits. */

    fad = (File *) calloc(1,sizeof(File));

    request->filemode = mode;

    Send( request, server );

    if ( reply->replycode != OK ) goto exception;

    fad->fileserver = reply->fileserver;
    fad->fileid = reply->fileid;
    fad->blocksize = reply->blocksize;
    fad->lastblock = reply->filelastblock;
    fad->lastbytes = reply->filelastbytes;
    fad->type = reply->filetype | localtype;

    return( fad );

exception:
    *error = reply->replycode;
    return( NULL );
  }
