/*
 * action.h
 *
 * Action table for Vload.  There is one entry for each possible
 *   first argument to Vload.  The fields in an entry represent
 *   the actions that are implied by the corresponding first
 *   argument.  The procedure for finding the values to use is
 *
 * 	1) See if the value was passed as a command line argument.
 *	2) If not, look in the action table.
 *	3) If the action table entry is NULL, do a QueryWorkstationConfig.
 *	4) Else use a compiled-in default.
 *
 * The last entry should have NULL as the firstarg; it is used when
 *   the first argument given does not match anything in the table.
 *   In that case the first argument is used as the team name.
 */

typedef struct
  {
    char *firstarg;	/* First arg to Vload that causes this action */
    char *world;	/* World to run in */
    char *team;	  	/* Team to load */
    char *kernel;	/* Kernel to load */
    char *options;	/* Options to pass */
  }
ActionTableEntry;
