/*
 * Vload Mark III -- A V loader using the V interkernel protocol
 *	and I/O protocol
 *
 * Command line arguments:
 * First argument is the team name.
 * Second argument is the kernel name.
 *   If equal to "#", specifies we are loading a standalone program.
 * Third argument is an option string.  
 *   Right now, the only option is `b', which says to break before 
 *   starting the kernel.  Someday there may be more.
 *
 * Tim Mann
 */
#include <Venviron.h>
#include <Vikc.h>
#include <Vmachine.h>
#include <b.out.h>
#include "process.h"
#include "action.h"
#ifdef SUN3
#include "sun3mem.h"
#endif
#ifdef SUN50
#include "sun2mem.h"
#endif
#ifdef ENP30
#include "ethercmc.h" /* to get ENP_LOAD_ORIGIN manifest */
#endif

#ifdef MC68000
#ifndef FF68K
#define K_START_1	0x1000		/* kernel start, sun-1 */
#define K_START_2	0x2000		/* kernel start, sun-1.5 and sun-2 */
#define V_T_START	0x20000		/* team start, V world */
#define XV_T_START	0x20000		/* team start, xV world */
#define VGTS		"team1-vgts.m68k"
#define STS		"team1-sts.m68k"
#else FF68K
#define K_START_1	0x20000		/* Having two kernel starts is just */
#define K_START_2	0x20000		/*   a leftover from Sun land       */
#define V_T_START	0x40000		/* team start, V world */
#define XV_T_START	0x40000		/* team start, xV world */
#define VGTS		"team1-sts.ff68k" /* No graphics -> no VGTS */
#define STS		"team1-sts.ff68k"
#endif FF68K
#else !MC68000
#ifdef VAX
#define K_START		0x0		/* kernel start, vaxen */
#define V_T_START	0x40000		/* team start, V world */
#define XV_T_START	0x40000		/* team start, xV world */
#define VGTS		"team1-vgts.vax"
#define STS		"team1-sts.vax"
#endif VAX
#endif MC68000
#define CONFIG_BUFF	0x20000
#define DEFAULT_WORLD	"V"
#define DEFAULT_TEAM	VGTS
#define DEFAULT_OPTIONS	""
#define MAX_NAME_LEN	256

char Loading[]="Loading ";
#ifdef ENP30
char OnBoard_Driver[] = "Vkernel/ethercmcob"; 
#endif

#ifdef ENET3MEG
/* ----------------------- 3 meg net version --------------------------- */

#define K_START		K_START_1
#define DEFAULT_KERNEL	"Vkernel/sun1+en"

#else
#ifdef EXCELAN
/* ----------------------- Excelan version ----------------------------- */

#define K_START		K_START_1
#define DEFAULT_KERNEL	"Vkernel/sun1+ex"

#else
#ifdef FF68K
/* ----------------------- 68010 Firefly ------------------------------- */

#define K_START		K_START_2 /* pretty meaningless */
#define DEFAULT_KERNEL	"Vkernel/ff68k"

#else
#ifdef SUN3
/* ----------------------- Sun-3 version ----------------------------- */
#define K_START		K_START_2
#define DEFAULT_KERNEL	"Vkernel/sun3+ie"

#else
#ifdef SUN50
/* ----------------------- Sun 50 version ----------------------------- */

#define K_START		K_START_2
#define DEFAULT_KERNEL	"Vkernel/sun50"

#else
#ifdef NDBOOT
/* ----------------------- 3Com/ND version ----------------------------- */

#define K_START		K_START_2
#define DEFAULT_KERNEL	"Vkernel/sun2+ec"

#else
#ifdef MICROVAX
/* --------------------------------------------------------------------- */

#define DEFAULT_KERNEL	"Vkernel/vaxu+qna"

#endif MICROVAX
#endif NDBOOT
#endif SUN50
#endif SUN3
#endif FF68K
#endif EXCELAN
#endif ENET3MEG

/* Here, we're (ab)using NDBOOT to mean Sun-2 style PROMs, I think */
#undef ND_OR_SUN3
#ifdef SUN3
#    define ND_OR_SUN3
#endif
#ifdef NDBOOT
#    define ND_OR_SUN3
#endif

#ifdef ND_OR_SUN3
#    include "bootparam.h"  /* to read "b" command line */
     /* Get next argument, or NULL if there are no more */
#    ifdef SUN3
#        include "sunromvec.h"
         char **argv;
#    else SUN3
         char **argv = BootParam->b_argv;
#    endif SUN3
#    define NextArg()	(*argv) ? (*argv++) : NULL
#else  ND_OR_SUN3
     char *NextArg();
#endif ND_OR_SUN3

SystemCode error;
char *Arena;
Process *Active;
extern int KernelPacketType;

/*
 * Action table.  Note that for the 10 Mbit Suns, autobooting or
 *   booting with no argument passes us the name "vmunix", so
 *   we have an appropriate entry for it below.  This is the same
 *   as the "" entry for 3 Mbit Suns. The last entry is a catch-all
 *   used when the first argument is not known to us.  In this case
 *   the first argument is used as the team name, the kernel name
 *   and world are taken from the config file if present, and the
 *   option string is forced to be empty.
 */
ActionTableEntry ActionTable[] =
  {
    /* firstarg, world, team, kernel, options */

#ifndef EXCELAN
    { "V", "V",	VGTS, NULL, "" },
    { "xV", "xV", VGTS, NULL, "" },
    { "VV", "V", STS, NULL, "" },
    { "xVV", "xV", STS, NULL, "" },
#ifdef ND_OR_SUN3
    { "vmunix", NULL, NULL, NULL, NULL },
#ifdef SUN3
    { "", NULL, NULL, NULL, NULL }, /* Sun-3 may not pass an argument ! */
#endif
#else /* not NDBOOT, not SUN3 */
    { "Vload", "V", "?Team: ", "?Kernel: ", "?Options: " },
    { "xVload", "xV", "?Team: ", "?Kernel: ", "?Options: " },
#ifdef MICROVAX
    { "V", "V", VGTS, NULL, ""},
    { "xV", "xV", VGTS, NULL, ""},
    { "Vload", "V", "?Team: ", "?Kernel: ", "?Options: "},
    { "xVload", "xV", "?Team: ", "?Kernel: ", "?Options: "},
#endif MICROVAX
    { "", NULL, NULL, NULL, NULL },
#endif ND_OR_SUN3
#else EXCELAN
    /* Versions of Vload that load off the 10Mbit net using an Excelan board
     * will (usually) have the prefix "xln", to distinguish them from the
     * equivalent variants of Vload that load off the 3Mbit net.
     */
    { "xlnV", "V", VGTS, NULL, "" },
    { "xlnxV", "xV", VGTS, NULL, "" },
    { "xlnVV", "V", STS, NULL, "" },
    { "xlnxVV", "xV", STS, NULL, "" },
    { "xlnVload", "V", "?Team: ", "?Kernel: ", "?Options: " },
    { "xlnxVload", "xV", "?Team: ", "?Kernel: ", "?Options: " },
#endif EXCELAN
    { NULL, NULL, "", NULL, "" }
  };


/*-------- Start of executable code ----------*/

#ifdef MC68000
    /* Move the loader up to the appropriate address and start it */
    asm("	.text		");
    asm("	.globl entry	");
    asm("entry:			");
#ifdef FF68K
    asm("_btext:		");  /* DEC SRC teledebugger (tdb) uses the */
				     /*   value of _btext to determine where*/
				     /*   to load text segment		    */
    asm("	movl #entry,sp	");
#else
    asm("	movl #/1000,sp	");  /* clear stack */
#endif FF68K
    asm("	movl #_edata-1,d0"); /* The dbra-loop moves (n+1) longs, so */
    asm("	subl #entry,d0	");  /*   this stuff moves:		    */
    asm("	asrl  #2,d0	");  /*  (trunc((_edata-entry-1)/4)+1)*4 =  */
				     /* trunc((_edata+3-entry)/4) * 4 bytes */
    asm("here:	lea pc@(entry-here-2),a0"); /* load-time address of "entry" */
    asm("	movl #entry,a1	");	    /* link-time address of "entry" */
    asm("loop:			");
    asm("   	movl a0@+,a1@+	");
    asm("	dbra d0,loop	");
   asm("	jsr main	");
#endif MC68000

#ifdef VAX
#ifdef MICROVAX
#include "ipl.h"
#include "bootparam.h"

RestartParamBlock RPB = {(char *)-1}; /* MUST NOT BE IN BSS! */
SecondBootArgs    SBA = {(long)  -1}; /* 	ditto	     */
char		  SBA_dummy = -1;	/* We rely on the compiler to put   */
					/* RPB, SBA, SBA_dummy sequentially */
					/* in the data segment, so the      */
					/* movc3's below do the right thing.*/
#define LONGS_PER_PCB 24
long		  dummy_PCB[LONGS_PER_PCB+1];
					/* We point the PCBB register here, */
					/* so that if the MicroVAX decides  */
					/* to flush registers to the PCB it */
					/* won't stomp on something vital.  */
					/* PCBB must be longword-aligned, so*/
					/* we allocate an extra long in case*/
#endif MICROVAX

    /* Move it up! */
    asm("	.text		");
    asm("	.globl entry	");
    asm("entry:			");
    asm("	movl	$0x30000,sp");
    asm("	movl	sp,fp");
#ifdef MICROVAX
    asm("	movc3	$(_SBA-_RPB), (r11), _RPB");	/* ) Must use PC-   */
    asm("	movc3	$(_SBA_dummy-_SBA),(ap),_SBA");	/* ) relative addrs */
#endif MICROVAX
    asm("	subl3	$entry, $_edata, r0");
    asm("	movc3	r0,entry,*$entry");		/* PC-rel, absolute */
    asm("	jmp	*$completed_move");		/* Must be absolute */
    asm("completed_move:");
    asm("	moval	_dummy_PCB+4,	r0");	/* Longword-align address */
    asm("	bicl2	$3,	r0");		/*   before putting it in */
    asm("	mtpr	r0,	$pcbb");	/*   the PCBB		  */
    asm("	subl3	$_edata, $_end, -(sp)");
    asm("	pushal	_edata");
    asm("	calls	$2, _clear");
    asm("	calls	$0, _main");

exit()
{
    puts("Halting\n\n");
    asm("        halt");
}
#endif VAX


main()
  {
#ifdef VAX
    register char *r11;
#endif VAX
#ifdef MC68000
    extern unsigned a1;			/* hack to access register a1 */
#endif MC68000
    register char *firstarg, *p;
    int standalone = 0;  		/* Load standalone program? */
    int breakfirst = 0;  		/* Break before starting? */
    int zerobss = 0;			/* Zero the bss in Vload? */
    unsigned long Kstart = K_START;	/* Kernel start address */
    unsigned long Tstart;		/* Team start address */
    unsigned long KBheader;		/* Kernel b.out header addr */
    unsigned long TBheader;		/* Team b.out header addr */
#ifdef ENP30
    unsigned long ObBheader;		/* On-board driver b.out header addr */
#endif ENP30
    unsigned long Kentry;
    register ActionTableEntry *action;
    char world[MAX_NAME_LEN], team[MAX_NAME_LEN],
	 kernel[MAX_NAME_LEN], options[MAX_NAME_LEN];
    char *opp;
    /* Global storage allocated on the stack to save space: */
    Process LoaderPd;
    char scratch[500];  /* for calloc */
#ifdef SUN50
    PageMapEntry newpage;
    
    /* Allocate the page that the 82586 uses for initialization
     */
    newpage.u = GetPageMap(0xB6000);
    SetPageMap(0xFFFFF6, newpage.u);    
    
    /* Change the pagemap entry for the prom to point to the
     * correct physical address.
     */
    newpage.u = GetPageMap(0xEF0000);
    SetPageMap(0x200000, newpage.u);
#endif SUN50

#ifdef SUN3
    argv = *(((struct sunromvec *) SUN3_ROM_VEC_PTR)->v_BootParam);
#endif
    Active = &LoaderPd;
    Arena = scratch;

    KernelPacketType = V_KERNEL_PACKET;
    EnetPowerup();

#ifdef ENP30
    puts("Enp-30 Vload\n");
#endif ENP30
    ReadConfigFile(CONFIG_BUFF);

    firstarg = NextArg();	  /* always at least one arg */
#ifdef ND_OR_SUN3
    while (*firstarg++ != ')') ;  /* skip the "nd(0,0,0)" cruft */
#endif ND_OR_SUN3

    /* Find the default action for the given first argument */
    action = &ActionTable[0];
    while (action->firstarg != NULL && strcmp(firstarg, action->firstarg))
	action++;

    if (action->firstarg != NULL)
	firstarg = NextArg();	/* first argument was special */
    
    /* Search for the proper value for world, teamname, kernelname,
     *   and options */
    GetValue(world, NULL, action->world, "world", DEFAULT_WORLD);
    GetValue(team, firstarg, action->team, "team", DEFAULT_TEAM);
    GetValue(kernel, NextArg(), action->kernel, "kernel", DEFAULT_KERNEL);
    GetValue(options, NextArg(), action->options, "boot-options",
	DEFAULT_OPTIONS);
    
    /* Figure out which world we're in */
    if (*world == 'x')
      {
	KernelPacketType = XV_KERNEL_PACKET;
	Tstart = XV_T_START;
      }
    else
      {
	KernelPacketType = V_KERNEL_PACKET;
	Tstart = V_T_START;
      }
    KBheader = Tstart - 2*sizeof(struct bhdr);
    TBheader = Tstart - sizeof(struct bhdr);
#ifdef ENP30
    ObBheader = ENP_LOAD_ORIGIN - sizeof(struct bhdr);
#endif ENP30
    puts(world);
    puts("-System\n");

    /* Parse options */
    opp = options;
    while (*opp)
      {
    	if (*opp == 'b')
	    breakfirst++;		/* Break before starting kernel */
#ifdef MC68000
	else if (*opp == '1')
	    Kstart = K_START_1;		/* Use kernel starting addr 1 */
	else if (*opp = '2')
	    Kstart = K_START_2;		/* Use kernel starting addr 2 */
#endif MC68000
	opp++;
      }

#ifdef FF68K
    /*
     * At present we use routines in the Firefly ROM to do character I/O.
     * These also have a tendency to check whether any packets have arrived for
     * the Firefly monitor, and this of course plays havoc with our Ethernet
     * routines.  So far the problem has only appeared (I think) after 
     * character input, i.e. when we prompt for team, kernel, etc.  If it is
     * ever caused by character output, we're in real trouble.
     */
    EnetPowerup();
#endif FF68K

    /* Now boot */
    if (*kernel != '#') 
      {
	/* Load team into team area */
	puts(Loading);
	puts(team);
	puts("\n");
        if ( (error = LoadFile(team, Tstart, TBheader, zerobss)) != OK)
	    ErrorExit(error);
#ifdef ENP30
	/* Load on-board driver into ethernet interface */
        /* But first clear the location that the enp will busy-wait on until
         *   the host sets the location with the appropriate value. */
        *((long *) SYS_JUMP_COMMAND_LOC) = 0;
	puts(Loading);
	puts(OnBoard_Driver);
	puts("\n");
        error = LoadFile(OnBoard_Driver, ENP_LOAD_ORIGIN, ObBheader, zerobss);
        if (error != OK ) 
          puts("Warning: could not locate on-board driver\n");
#endif ENP30
      }
    else
      {
	/* Load standalone program into kernel area */
	strcpy(kernel, team);
#ifdef undef /* We make the standalone programs zero their own bss. */
	zerobss = 1;
#endif

	/* Put header out of the way of large programs */
	KBheader = (unsigned long) calloc(1, sizeof(struct bhdr));
      }


    /* Load kernel (or standalone program) into its area */
    puts(Loading);
    puts(kernel);
    puts("\n");
    if ( (error = LoadFile(kernel, Kstart, KBheader, zerobss)) != OK)
	ErrorExit(error);

#ifdef MC68000
    a1 = ((struct bhdr *) KBheader)->entry;
#endif MC68000
#ifdef VAX
    r11 = (char *)((struct bhdr *) KBheader)->entry;
    asm("	movl	r11, r10");
#ifdef MICROVAX
    /*
     * The MicroVAX bootstrap gave us various magic parameters.  We try to
     *   pass these on in the same fashion, but there are inevitable changes.
     *   We copied the Restart Parameter Block and the Secondary Bootstrap
     *   arguments into Vload, and then probably stomped all over VMB (the
     *   MicroVAX's Primary Bootstrap).  We make no attempt to fix addresses
     *   in either of these data structures, so they may well point to the
     *   wrong place or point to somewhere we've stomped on (e.g. if VMB 
     *   really built a bitmap and we overwrote VMB, we'd be in trouble;
     *   fortunately, it seems just to use the one from the Monitor).
     *   The RPB will most likely not be page-aligned.  
     * VMB also gave us a stack pointer which pointed somewhere useful (we
     *   ignored it, and have probably loaded the kernel/team into that area)
     *   and a SCBB which pointed to an initialized SCB (ditto).  Since we
     *   can't be bothered doing something compatible, we put garbage in
     *   the SCBB.  We don't put garbage in the SP, only because the Monitor
     *   will object if we RETURN_TO_MONITOR and then try continuing.
     * The only thing we actually fix is the length of the Secondary 
     *   Bootstrap argument list; if it was bigger than we thought (hence we
     *   didn't copy it all), we reduce the length field.
     */
    if (SBA.argSize > sizeof(SBA)/sizeof(long)-1)
	SBA.argSize = sizeof(SBA)/sizeof(long)-1;
    asm("	movl	r11, r10"); /* In case we clobbered r10 above */
    asm("	moval	_RPB, r11");
    asm("	moval	_SBA, ap");
    asm("	mtpr	$-512, $scbb");/* Trash the SCBB */
#endif MICROVAX
#endif VAX

    /* 
     * Break before starting kernel?  Hope piously that this doesn't:
     *   - rely on something we've just destroyed
     *   - destroy something we've just set up.
     * We could do this earlier, but the idea was to show the complete state
     * just before we jump to the new kernel or standalone.
     */
    if (breakfirst)
      {
	RETURN_TO_MONITOR;
      }
 
#ifdef SUN50
    /* Return the 82586 initialization page
     */
    newpage.u = GetPageMap(0xFFFFF6);
    SetPageMap(0xB6000, newpage.u);
#endif   
#ifdef MC68000
    ;asm(" movl #0,a6");
    ;asm(" movl #/1000,a7"); /* reclaim stack space */
    ;asm(" jmp a1@");  /* leading semicolon is ESSENTIAL (compiler bug) */
#endif MC68000
#ifdef VAX
    ;asm(" 	jmp (r10)");
#endif VAX

  }

#ifdef MICROVAX
char *NextArg()
  {
    static int whichArg = 0;
    
    if (whichArg++ > 0)
        return(NULL);
    else
      {
        switch(RPB.savedregs[5] & 7)
	  {
	  case 0:	return(NULL);
	  case 1:	return("V");
	  case 2:	return("xV");
	  case 3:	return("Vload");
	  case 4:	return("xVload");
	  default:	return(NULL);
	  }
      }
  }
#endif MICROVAX

#ifdef MC68000
#ifdef FF68K
/*
 * We don't know of a sensible way to get boot arguments from the 68010 
 *   Firefly monitor, so we default to xVload.  May eventually want to change
 *   this to xV (will probably have to add an entry to ActionTable).
 */
char *NextArg()
  {
    static int whichArg = 0;
    
    if (whichArg++ > 0)
        return(NULL);
    else
	return("xVload");
  }
#else  FF68K
#ifndef ND_OR_SUN3
/*
 * Simulate retrieving the next command line argument.
 *   The first argument is always the name typed on the "b" or
 *   "n" command line if any, or "" if we were autobooted.  The other
 *   arguments are NULL since we can only get one argument in this world.
 */
#include <confreg.h>

/* Lineptr in PROM GlobRam struct.  We don't bother trying to
 *   include three conflicting sets of header files, just define
 *   the three versions of the one location we need. */
#define CadlincLineptr (*(char **) 0x25a)
#define SmiLineptr (*(char **) 0x2c0)
#define OldSmiLineptr (*(char **) 0x2ba)  /* Rev C PROMs */

char *NextArg()
  {
    static int whichArg = 0;
    short config, version;

    if (whichArg++ > 0) return (NULL);

    /* Figure out whether we autobooted, and if not, find our name */

#ifdef MC68000
    version = K_version();
    config = K_getconfig();
#endif MC68000

    if (version == 101)
      {
	/* This is an SMI Sun-1 with Rev C PROMs */
	return (OldSmiLineptr);
      }
    else if (version == 0x200)
      {
	/* This is an SMI Sun-1 with Rev D PROMs */
	return (SmiLineptr);
      }
    else
      {
	/* This is a Cadlinc or Stanford prototype Sun.
         *  Check bootfile number in config register. */
	if ( ((struct ConfReg *)&config)->Bootfile == BOOT_TO_MON ||
	     ((struct ConfReg *)&config)->Bootfile == BOOT_SELF_TEST )
	  {
	    return (CadlincLineptr);	/* Normal boot */
	  }
	else
	  {
	    return ("");		/* Autoboot */
	  }
      }
  }
#endif ND_OR_SUN3
#endif FF68K
#endif MC68000

ErrorExit(error)
    int error;
  {
    puts("Error: reply code = ");
    PutShortHex(error);
#ifdef LOTS_OF_ROOM
    puts(" (");
    puts(ErrorString(error));
    puts(")");
#endif LOTS_OF_ROOM
    puts("\n");
    RETURN_TO_MONITOR;
  }


#ifdef undef
/* This is a quick hack to print out addresses - Lance */
puthex(addr)
register unsigned long addr;
  {
    extern K_putchar();
    register int i;
    static unsigned char s[] = "0123456789abcdef";
    register unsigned char *c;
    c = s;
    for (i = 8; i != 0 ; i--)
      {
    	K_putchar(*(c+(addr>>28)));
	addr <<= 4;
      }
  }

abort(){ puts(" abort() was called. Whoopee.\n"); }
#endif undef

#ifdef MICROVAX
 /* make sure that this routine is linked in from libVconsole.a */
#ifdef undef /* Why would we be so desperate to link in that? */
nevercalled() { return_K_ticks(); }
#endif undef
#endif MICROVAX
