#include "enetxln.h"

/* NOTE:
 * The following global variable declarations are omitted, being replaced by
 * the manifest definitions that follow. (These definitions replace variable
 * assignments that originally appeared in "enopen"). This was done to
 * reduce code space, and because this code was derived from code that was put
 * in ROM.
 */

#ifdef USE_GLOBALS
/*
 * Significant addresses referring to Multibus memory.
 */

unsigned	MultibusMemAddr;	/* Base address of my area of */
					/* Multibus memory. */
char		*VMultibusMemAddr;	/* Virtual address of above. */

char		*ReadDataBuf;		/* Buffer for incoming packets. */
char		*WriteDataBuf;		/* Buffer for outgoing packets. */
char		*StatsBuffer;		/* Buffer for statistics replies. */

struct MsgQs	*MsgQPtr;		/* Start of request/reply queues. */
unsigned	MsgQVirAddr;		/* Virtual address of same. */
unsigned	MsgQPhysAddr;		/* Physical address of same. */
unsigned	MsgQVirSegAddr;		/* Start of segment of same--Exos's */
					/*  16 bit offsets are calculated */
					/*  from here.  Luckily, the */
					/*  AllocateMultibusMemory routine */
					/*  returns areas which begin or end*/
					/*  on a segment boundary. */
#else USE_GLOBALS

#define MultibusMemAddr 0x0000
#define VMultibusMemAddr 0x100000
#define systembuf ( (struct SystemBuffers *) VMultibusMemAddr )
#define ReadDataBuf ( systembuf->readbuffer )
#define WriteDataBuf ( systembuf->writebuffer )
#define StatsBuffer ( systembuf->statsbuffer )
#define MsgQVirAddr ( (long)(VMultibusMemAddr+sizeof(struct SystemBuffers)) )
#define MsgQPhysAddr ( VirToPhys(MsgQVirAddr) )
#define MsgQVirSegAddr ( MsgQVirAddr & (~0xffff) )
#define MsgQPtr ( (struct MsgQs *) MsgQVirAddr )


#endif USE_GLOBALS

/* In this version of the Excelan driver, we only have 1 buffer of each kind, so
 * we redefine the following constants.
 */
#undef   NREQBUFS
#undef   NREPBUFS
#define   NREQBUFS	1
#define   NREPBUFS	1


/* Miscellaneous things which aren't defined in "/xV/kernel/m68k/enetxln.h",
 * but should be.
 */

/*
 * Error status bits on read (return codes)
 * Also used in the option mask field
 */
# define PacketTooLong 0x04
# define AlignmentError 0x10
# define CRCError 0x20

/*
 * Net mode field
 */
# define Promiscuous 3
# define CONNECT_TO_NET	2

