/*
 *              Vax graphics library.
 *              Swiped from Sun version.
 */

/* General line drawing routine (uses Bresenham's algorithm). */
/* Exports:     Vax_Line(). */

#include <Vfont.h>

extern VRaster *WholeScreen;
#define ScreenLimitX (WholeScreen[-1].bBox.h)
#define ScreenLimitY (WholeScreen[-1].bBox.v)
#define ScreenWidth  (WholeScreen[-1].stride)     /* screen width in bytes */
#define GXBase       (WholeScreen[-1].start)    /* Start address of bitmap */

Vax_Line(x, y, dx, dy)
    unsigned short x, y;
	     short dx, dy;              /* Can be negative */
    /* Draws a (1 pixel wide) line from (x,y) to (x+dx,y+dy). */
  {
    register long  lineBit;            /* r11 */
    register short e, majCount;
    register BitUnit *pointAddr;

    int      screenWidth = ScreenWidth;

    /* Change the parameters so that "dx" > 0. */
    if (dx < 0)
      {
	x -= (dx = -dx);
	y -= (dy = -dy);
      }
    if (x + dx > ScreenLimitX) return; /* integrity check. */

    /* Compute the address of the origin point (x,y): */
    pointAddr = GXBase;            /* Frame buffer base address */
    pointAddr += y * screenWidth;  /* + rows above the point */
    pointAddr += (x>>3) & ~1;		/* + space to the left */
        
    /* Set up "lineBit", a 1-bit value that will be or'd into the framebuffer
     * to draw the line.
     */
    lineBit = 0x0001<<(x & 15);

    /* We consider the following four cases (each angle is 45 degrees):
     *
     *-Y
     * |     /
     * | 3  /
     * |   /
     * |  /
     * | /  4
     * |/
     * *--------> +X
     * |\
     * | \  2
     * |  \
     * |   \
     * | 1  \
     * |     \
     *+Y
     *
     */
    if (dy < 0)
      { /* Case 3 or 4. */
	dy = -dy;
	if ( ((int)(y - dy) < 0) || (y >= ScreenLimitY) )
	    return; /* integrity check. */
	screenWidth = -screenWidth; /* move 'upwards' instead of 'downwards'. */
      }
    else /* (dy >= 0) */
      { /* Case 1 or 2. */
	if (y + dy >= ScreenLimitY) return; /* integrity check. */
      }

    /* Draw the line. */
    if (dx <= dy)
      { /* Case 1 or 3 - major direction is Y, minor is X. */
	majCount = dy;
	e = -dy;
	dx <<= 2; dy <<= 2; /* multiply each by 4. */
	do  /* (minor direction loop) */
	  {
	    do                         /*  (major direction loop) */
	      {
		*(long *)pointAddr &= ~lineBit; /* plot a point. */
		pointAddr += screenWidth;
		e += dx;
	      }  while ((e <= 0) && (--majCount != -1));
	    asm("rotl $1,r11,r11");     /* rotate "lineBit" left by 1. */
	    if (lineBit == 0x0001)
		pointAddr += 4;
	    e -= dy;
	  }
	while (--majCount >= 0);
      }
    else /* (dx > dy) */
      { /* Cases 2 or 4 - major direction is X, minor is Y. */
	majCount = dx;
	e = -dx;
	dx <<= 1; dy <<= 1; /* multiply each by 2. */
	do  /* (minor direction loop) */
	  {
	    do              /* (major direction loop) */
	      {
		*(long *)pointAddr &= ~lineBit; /* plot a point. */
		asm("rotl $1,r11,r11");     /* rotate "lineBit" left by 1. */
		if (lineBit == 0x0001)
		    pointAddr += 4;
		e += dy;
	      } while ((e <= 0) && (--majCount != -1));
	    pointAddr += screenWidth;
	    e -= dx;
	  }
	while (--majCount >= 0);
      }
  }
