/* A VGTS 'bootstrap' program.  This program queries the kernel to find the
 * framebuffer type, loads the appropriate version of the VGTS, and then 'dies'
 * (so that it doesn't waste a team.)
 */

#include <Venviron.h>
#include <Vio.h>
#include <Vquerykernel.h>
#include <Vteams.h>

main()
  {
    PeripheralConfigurationReply preply;
    register i;

    QueryKernel(0, PERIPHERAL_CONFIG, &preply);
    for (i = 0; i < MAX_PERIPHERALS; ++i)
	switch (preply.peripheral[i])
	  {
	    case PRF_FRAMEBUFFER_SMI100:
		loadVgts("sun100vgts");
		return;
		    
	    case PRF_FRAMEBUFFER_SMI120:
	    case PRF_FRAMEBUFFER_SUN3:
		loadVgts("sun120vgts");
		return;

	    case PRF_FRAMEBUFFER_QVSS:
	        loadVgts("mvaxvgts");
		return;
	  }
    if (i == MAX_PERIPHERALS)
      {
	fprintf(stderr, "Couldn't find a framebuffer - loading \"sts\"\n");
	loadVgts("sts");
      }
  }

char *progArgv[2] = {"", NULL};

loadVgts(vgtsName)
    char vgtsName[];
    /* loads and runs the program called "vgtsName" as the VGTS. */
  {
    ProcessId newPid;
    SystemCode error;

    progArgv[0] = vgtsName;

    newPid = ExecProgram(progArgv, NULL, NULL, NULL, NULL, &error);
    if (newPid == 0) 
      {
	fprintf(stderr, "Failed to start %s: %s\n",
			vgtsName, ErrorString(error));
	exit();
      }
  }
