/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * This file contains the definitions for the stipple patterns to be
 * used in drawing rectangles.  It also contains the routine which
 * draws the rectangles in terms of the indices of these stipple patterns.
 *
 * Update history --
 *	4/20/85 Gus Fernandez - Allowed use of pattern definitions
 *		in filled rectangles (see patdefs.c) by adding
 *		STIPPLE_OFFSET to the pattern.
 */

#include "Vgts.h"

extern short *Patterns[]; 	/*from patterns.c */

static short MetalStip[] = {
		 	0x3333, 0xCCCC, 0x0000, 0x0000,
			0x3333, 0xCCCC, 0x0000, 0x0000,
			0x3333, 0xCCCC, 0x0000, 0x0000,
			0x3333, 0xCCCC, 0x0000, 0x0000 };

static short PolyStip[] = {
			0x8888, 0x4444, 0x2222, 0x1111,
			0x8888, 0x4444, 0x2222, 0x1111,
			0x8888, 0x4444, 0x2222, 0x1111,
			0x8888, 0x4444, 0x2222, 0x1111 };

static short DiffStip[] = {
			0x4444, 0x0000, 0x1111, 0x0000,
			0x4444, 0x0000, 0x1111, 0x0000,
			0x4444, 0x0000, 0x1111, 0x0000,
			0x4444, 0x0000, 0x1111, 0x0000 };

static short IonStip[] = {
			0x4444, 0x0000, 0x4444, 0x0000,
			0x4444, 0x0000, 0x4444, 0x0000,
			0x4444, 0x0000, 0x4444, 0x0000,
			0x4444, 0x0000, 0x4444, 0x0000 };

static short CutStip[] = {
			0x3333, 0xBBBB, 0x8888, 0xEEEE,
			0x3333, 0xBBBB, 0x8888, 0xEEEE,
			0x3333, 0xBBBB, 0x8888, 0xEEEE,
			0x3333, 0xBBBB, 0x8888, 0xEEEE };

static short GlassStip[] = {
			0x6666, 0x9999, 0x9999, 0x6666,
			0x6666, 0x9999, 0x9999, 0x6666,
			0x6666, 0x9999, 0x9999, 0x6666,
			0x6666, 0x9999, 0x9999, 0x6666 };

/*
 * Tom Davis made these up -- the others come from 
 * Kevin Karplus
 */

static short BuriedStip[] = {
			0xF0F0, 0x0F0F, 0xF0F0, 0x0F0F,
			0xF0F0, 0x0F0F, 0xF0F0, 0x0F0F,
			0xF0F0, 0x0F0F, 0xF0F0, 0x0F0F,
			0xF0F0, 0x0F0F, 0xF0F0, 0x0F0F };

static short BlackStip[] = {
			0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
			0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
			0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
			0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };

static short GrayStip[] = {
			0xAAAA, 0x5555, 0xAAAA, 0x5555,
			0xAAAA, 0x5555, 0xAAAA, 0x5555,
			0xAAAA, 0x5555, 0xAAAA, 0x5555,
			0xAAAA, 0x5555, 0xAAAA, 0x5555 };


extern short GridStip[];

/*
 * DrawRect:
 * Draws a rectangle at screen coords. (x, y) of height h and width w.
 * The rectangle is drawn with a stipple pattern whose index is indicated
 * by the value of layer. 
 */

DrawRect(x, y, w, h, layer)
short x, y, w, h;
unsigned char layer;
{
  short *stip_ptr;

  switch (layer)
    {
      case NP: stip_ptr = PolyStip; break;
      case NM: stip_ptr = MetalStip; break;
      case ND: stip_ptr = DiffStip; break;
      case NI: stip_ptr = IonStip; break;
      case NG: stip_ptr = GlassStip; break;
      case NB: stip_ptr = BuriedStip; break;
      case NC: stip_ptr = CutStip; break;
      case ZZ: stip_ptr = GridStip; break;	/* draws a grid */
      case BLACK: stip_ptr = BlackStip; break;	/* draws solid black */
      case GRAY:  stip_ptr = GrayStip; break;	/* gray  */
      case HILIGHT: stip_ptr = DiffStip; break;	/* like ND, but unselectable */
      default:
	if ( layer < STIPPLE_OFFSET )
	    return;
	if (( layer - STIPPLE_OFFSET ) >= MAX_FILL_PATTERN_INDEX )
	    return;
	stip_ptr = Patterns[layer-STIPPLE_OFFSET]; /* pattern defs */
    }
  PaintRectangle(x, y, w, h, stip_ptr);
}
