/************************************************/
/*						*/
/*	       (C)  COPYRIGHT 1983		*/
/*		BOARD OF TRUSTEES		*/
/*	LELAND STANFORD JUNIOR UNIVERSITY	*/
/*	  STANFORD, CA. 94305, U. S. A.		*/
/*						*/
/************************************************/
 
/*
 *  patdefs.c
 *
 *  This file defines all of the various fill patterns used in the
 *  XY system.  By convention, a 0 bit represents a white pixel.
 *
 *  Update History:
 *	March 1983 -- Written by David Kaelbling.
 */
    
#include "Vgts.h"

    
/* Exports */
extern short *Patterns[];
    
    
/* Local definitions */
static short White[] =
  {
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
  };
    
static short Black[] =
  {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  };
    
static short Gray[] =
  {
    0xAAAA, 0x5555, 0xAAAA, 0x5555,
    0xAAAA, 0x5555, 0xAAAA, 0x5555,
    0xAAAA, 0x5555, 0xAAAA, 0x5555,
    0xAAAA, 0x5555, 0xAAAA, 0x5555,
  };
    
static short StripeLeft[] =
  {
    0x3333, 0x9999, 0xCCCC, 0x6666,
    0x3333, 0x9999, 0xCCCC, 0x6666,
    0x3333, 0x9999, 0xCCCC, 0x6666,
    0x3333, 0x9999, 0xCCCC, 0x6666,
  };
    
static short BigStripeLeft[] =
  {
    0x0F0F, 0x8787, 0xC3C3, 0xE1E1,
    0xF0F0, 0x7878, 0x3C3C, 0x1E1E,
    0x0F0F, 0x8787, 0xC3C3, 0xE1E1,
    0xF0F0, 0x7878, 0x3C3C, 0x1E1E,
  };
    
static short StripeRight[] =
  {
    0xCCCC, 0x9999, 0x3333, 0x6666,
    0xCCCC, 0x9999, 0x3333, 0x6666,
    0xCCCC, 0x9999, 0x3333, 0x6666,
    0xCCCC, 0x9999, 0x3333, 0x6666,
  };
    
static short BigStripeRight[] =
  {
    0xF0F0, 0xE1E1, 0xC3C3, 0x8787,
    0x0F0F, 0x1E1E, 0x3C3C, 0x7878,
    0xF0F0, 0xE1E1, 0xC3C3, 0x8787,
    0x0F0F, 0x1E1E, 0x3C3C, 0x7878,
  };
    
static short CrossHatch[] =
  {
    0x8888, 0x5555, 0x2222, 0x5555,
    0x8888, 0x5555, 0x2222, 0x5555,
    0x8888, 0x5555, 0x2222, 0x5555,
    0x8888, 0x5555, 0x2222, 0x5555,
  };
    
static short BigCrossHatch[] =
  {
    0xE7E7, 0xC3C3, 0xE7E7, 0xFFFF,
    0x7E7E, 0x3C3C, 0x7E7E, 0xFFFF,
    0xE7E7, 0xC3C3, 0xE7E7, 0xFFFF,
    0x7E7E, 0x3C3C, 0x7E7E, 0xFFFF,
  };
    
static short ChainLink[] =
  {
    0xC3C3, 0x6666, 0x3C3C, 0x6666,
    0xC3C3, 0x6666, 0x3C3C, 0x6666,
    0xC3C3, 0x6666, 0x3C3C, 0x6666,
    0xC3C3, 0x6666, 0x3C3C, 0x6666,
  };
  
static short Dots[] =
  {
    0x3333, 0x3333, 0xCCCC, 0xCCCC,
    0x3333, 0x3333, 0xCCCC, 0xCCCC,
    0x3333, 0x3333, 0xCCCC, 0xCCCC,
    0x3333, 0x3333, 0xCCCC, 0xCCCC,
  };
  
static short Checkers[] =
  {
    0x3C3C, 0x3C3C, 0xC3C3, 0xC3C3,
    0xC3C3, 0xC3C3, 0x3C3C, 0x3C3C,
    0x3C3C, 0x3C3C, 0xC3C3, 0xC3C3,
    0xC3C3, 0xC3C3, 0x3C3C, 0x3C3C,
  };
    
static short SquareDots[] =	/* by Mistake */
  {
    0x0F0F, 0x6969, 0x6969, 0x0F0F,
    0xF0F0, 0x9696, 0x9696, 0xF0F0,
    0x0F0F, 0x6969, 0x6969, 0x0F0F,
    0xF0F0, 0x9696, 0x9696, 0xF0F0,
  };
    
static short Pinwheels[] =	/* by J.E.B */
  {
    0xDDDD, 0x1111, 0x8888, 0xBBBB,
    0xDDDD, 0x1111, 0x8888, 0xBBBB,
    0xDDDD, 0x1111, 0x8888, 0xBBBB,
    0xDDDD, 0x1111, 0x8888, 0xBBBB,
  };
    
static short Roses[] =		/* by J.E.B. */
  {
    0xF1F1, 0x0505, 0x7D7D, 0x2525,
    0xA4A4, 0xBEBE, 0xA0A0, 0x8F8F,
    0xF1F1, 0x0505, 0x7D7D, 0x2525,
    0xA4A4, 0xBEBE, 0xA0A0, 0x8F8F,
  };
    
static short Math[] =		/* by D.P.H. */
  {
    0xC6C6, 0xEFEF, 0x7D7D, 0x3939,
    0x7D7D, 0xEFEF, 0xC6C6, 0x7C7C,
    0xC6C6, 0xEFEF, 0x7D7D, 0x3939,
    0x7D7D, 0xEFEF, 0xC6C6, 0x7C7C,
  };
    
static short Rug[] =		/* by J.D.M. */
  {
    0xB76D, 0x6AB6, 0xDFDB, 0xA2E5,
    0x6B66, 0xA2DB, 0xFDBD, 0xAB6E,
    0x76D5, 0xBDBF, 0xDB45, 0x66D6,
    0xA745, 0xDBFB, 0x6D56, 0xB6ED,
  };
    
static short DeskTop[] =	/* by P.J.A. */
  {
    0xDDDD, 0xDDDD, 0x7777, 0x7777, 
    0xDDDD, 0xDDDD, 0x7777, 0x7777, 
    0xDDDD, 0xDDDD, 0x7777, 0x7777, 
    0xDDDD, 0xDDDD, 0x7777, 0x7777, 
  };
    
static short Cubes[] =		/* by P.J.A. */
  {
    0xE6E6, 0x9898, 0x7E7E, 0x9898,
    0xE6E6, 0xEEEE, 0xEEEE, 0xEEEE,
    0x6E6E, 0x8989, 0xE7E7, 0x8989,
    0x6E6E, 0xEEEE, 0xEEEE, 0xEEEE,
  };    

static short Wicker[] =		/* by the program itself */
  {
    0xDFDF, 0xD3D3, 0xBCBC, 0xBFBF,
    0xFDFD, 0x3D3D, 0xCBCB, 0xFBFB,
    0xDFDF, 0xD3D3, 0xBCBC, 0xBFBF,
    0xFDFD, 0x3D3D, 0xCBCB, 0xFBFB,
  };
 
static short Herringbone[] =	/* by L.E.P. */
  {
    0x6C6C, 0x3939, 0x9393, 0xC6C6,
    0x6C6C, 0x3939, 0x9393, 0xC6C6,
    0x6C6C, 0x3939, 0x9393, 0xC6C6,
    0x6C6C, 0x3939, 0x9393, 0xC6C6,
  };
  
static short Tangle[] =		/* by committee */
  {
    0x2323, 0x3737, 0x3F3F, 0x1B1B,
    0x0909, 0xD9D9, 0xF9F9, 0xB1B1,
    0x2323, 0x3737, 0x3F3F, 0x1B1B,
    0x0909, 0xD9D9, 0xF9F9, 0xB1B1,
  };
    
static short Web[] =		/* by D.P.H. */
  {
    0x5501, 0x55FF, 0x5501, 0x55FF,
    0x5501, 0x55FF, 0x5501, 0x55FF,
    0x0155, 0xFF55, 0x0155, 0xFF55,
    0x0155, 0xFF55, 0x0155, 0xFF55,
  };
    
static short Weave[] =		/* by L.E.P. */
  {
    0x8035, 0xFFF5, 0x8035, 0xFFF5,
    0xFFF5, 0xF5F5, 0xF5FF, 0xF5FF,
    0x3580, 0xF5FF, 0x3580, 0xF5FF,
    0xF5FF, 0xF5F5, 0xFFF5, 0xFFF5,
  };
    
static short Trees[] =		/* by L.E.P. */
  {
    0x0003, 0x0003, 0xFCC3, 0xFCC3,
    0x3CF3, 0x3CF3, 0x0CFF, 0x0CFF,
    0x0003, 0x0003, 0xFCC3, 0xFCC3,
    0x3CF3, 0x3CF3, 0x0CFF, 0x0CFF,
  };
    
static short Columns[] =
  {
    0x3333, 0x3333, 0x3333, 0x3333,
    0x3333, 0x3333, 0x3333, 0x3333,
    0x3333, 0x3333, 0x3333, 0x3333,
    0x3333, 0x3333, 0x3333, 0x3333,
  };
    
static short Rows[] =
  {
    0x0000, 0x0000, 0xFFFF, 0xFFFF,
    0x0000, 0x0000, 0xFFFF, 0xFFFF,
    0x0000, 0x0000, 0xFFFF, 0xFFFF,
    0x0000, 0x0000, 0xFFFF, 0xFFFF,
  };
    
static short Matrix[] =
  {
    0x3333, 0x3333, 0xFFFF, 0xFFFF,
    0x3333, 0x3333, 0xFFFF, 0xFFFF,
    0x3333, 0x3333, 0xFFFF, 0xFFFF,
    0x3333, 0x3333, 0xFFFF, 0xFFFF,
  };
    
/* Export an array of these definitions */
short *Patterns[MAX_FILL_PATTERN_INDEX] =
  {
    White,
    Black,
    Gray,
    StripeLeft,
    BigStripeLeft,
    StripeRight,
    BigStripeRight,
    CrossHatch,
    BigCrossHatch,
    ChainLink,
    Dots,
    Checkers,
    SquareDots,
    Pinwheels,
    Roses,
    Math,
    Rug,
    DeskTop,
    Cubes,
    Wicker,
    Herringbone,
    Tangle,
    Web,
    Weave,
    Trees,
    Columns,
    Rows,
    Matrix,
  };
