/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * pad.h - private declarations for the VGTS terminal emulator
 *
 * Bill Nowicki September 1982
 */

enum PadState 
  {
  	/*
	 * This enumerated type defines the current state of an output pad.
	 */
    Normal,		/* just print characters */
    GettingArgs,	/* decoding arguments of escape sequence */
    Escape,		/* decode and escape sequence */
    GettingCharSet	/* decode the VT-100 character set descriptor */
  };

enum EscapeKind 
  {
    NonAnsi,		/* just escape followed by a character */
    Ansi		/* escape, left bracket, character */
  };

typedef struct TtyPadRec
	/* Descriptor for a tty pad.  Contains various 
	   constants which define the pads state. */
  {
    char *cursorPos;		/* pointer to a cursor position */
    short width, length;	/* Width and length of the pad in chars */
    short curColumn, curLine;	/* Current column and line numbers. */
    DisplayRecord *curItem;	/* points to current item in the SDF */
    short yMinChanged;		/* bounds to be refreshed on next */
    short yMaxChanged;		/* 			cursor flash */
    enum PadState state;	/* state we are in */
    char *strings;		/* space malloc'ed for strings */
    short args[5];		/* save parameters of commands */
    short regionTop, regionBot;	/* region bounds for VT-100 style scrolling */
    char cursorFlag;		/* true if cursor is on */
    char standout;		/* true if in standout mode */
    char insert;		/* true if in insert mode */
    char argCount;		/* number arguments */
    DisplayRecord *sdfPtr;	/* root of the symbol */
    short vgt;			/* vgt index */
    short pageLength;		/* how big a screenful is */
    short newlinesLeft;		/* # newlines until block with a screenful */
    char junk[8];		/* extra to make a power of two */
   } TtyPadRec, TtyPadType;

extern TtyPadType TtyPadList[];

