/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* keytable.c - Keytable for Line Editing
 *
 *
 * Bill Nowicki September 1983 
 *
 */
#include <Vio.h>
#include <Vtermagent.h>

enum EditKind KeyTable[128] =
     {
	EditNop,		/* Null */
	EditBeginLine,		/* control A */
	EditBackwardChar,	/* control B */
	EditKillBreak,		/* control C */
	EditDeleteNextChar,	/* control D */
	EditEndLine,		/* control E */
	EditForwardChar,	/* control F */
	EditRelease,		/* control G */
	EditDeleteChar,		/* control H */
	EditInsertTab,		/* control I */
	EditReleaseLine,	/* control J */
	EditDeleteNextLine,	/* control K */
	EditNop,		/* control L */
	EditReleaseLine,	/* control M */
	EditNop,		/* control N */
	EditNop,		/* control O */
	EditNop,		/* control P */
	EditNop,		/* control Q */
	EditNop,		/* control R */
	EditNop,		/* control S */
	EditTransposeChar,	/* control T */
	EditDeleteLine,		/* control U */
	EditNop,		/* control V */
	EditDeleteWord,		/* control W */
	EditNop,		/* control X */
	EditNop,		/* control Y */
	EditEOF,		/* control Z */
	       
	EditEscape,		/* ESC */
	EditNop,		/* FS */
	EditNop,		/* GS */
	EditInsert,		/* RS */
	EditNop,		/* US */
	
	EditInsert,		/* Space */
	EditInsert,		/* ! */
	EditInsert,		/* " */
	EditInsert,		/* # */
	EditInsert,		/* $ */
	EditInsert,		/* % */
	EditInsert,		/* & */
	EditInsert,		/* ' */
	EditInsert,		/* ( */
	EditInsert,		/* ) */
	EditInsert,		/* * */
	EditInsert,		/* + */
	EditInsert,		/* , */
	EditInsert,		/* - */
	EditInsert,		/* . */
	EditInsert,		/* / */
	EditInsert,		/* 0 */
	EditInsert,		/* 1 */
	EditInsert,		/* 2 */
	EditInsert,		/* 3 */
	EditInsert,		/* 4 */
	EditInsert,		/* 5 */
	EditInsert,		/* 6 */
	EditInsert,		/* 7 */
	EditInsert,		/* 8 */
	EditInsert,		/* 9 */
	EditInsert,		/* : */
	EditInsert,		/* ; */
	EditInsert,		/* < */
	EditInsert,		/* = */
	EditInsert,		/* > */
	EditInsert,		/* ? */

	EditInsert,		/* @ */
	EditInsert,		/* A */
	EditInsert,		/* B */
	EditInsert,		/* C */
	EditInsert,		/* D */
	EditInsert,		/* E */
	EditInsert,		/* F */
	EditInsert,		/* G */
	EditInsert,		/* H */
	EditInsert,		/* I */
	EditInsert,		/* J */
	EditInsert,		/* K */
	EditInsert,		/* L */
	EditInsert,		/* M */
	EditInsert,		/* N */
	EditInsert,		/* O */
	EditInsert,		/* P */
	EditInsert,		/* Q */
	EditInsert,		/* R */
	EditInsert,		/* S */
	EditInsert,		/* T */
	EditInsert,		/* U */
	EditInsert,		/* V */
	EditInsert,		/* W */
	EditInsert,		/* X */
	EditInsert,		/* Y */
	EditInsert,		/* Z */
	EditInsert,		/* [ */
	EditInsert,		/* \ */
	EditInsert,		/* ] */
	EditInsert,		/* ^ */
	EditInsert,		/* _ */

	EditInsert,		/* ` */
	EditInsert,		/* a */
	EditInsert,		/* b */
	EditInsert,		/* c */
	EditInsert,		/* d */
	EditInsert,		/* e */
	EditInsert,		/* f */
	EditInsert,		/* g */
	EditInsert,		/* h */
	EditInsert,		/* i */
	EditInsert,		/* j */
	EditInsert,		/* k */
	EditInsert,		/* l */
	EditInsert,		/* m */
	EditInsert,		/* n */
	EditInsert,		/* o */
	EditInsert,		/* p */
	EditInsert,		/* q */
	EditInsert,		/* r */
	EditInsert,		/* s */
	EditInsert,		/* t */
	EditInsert,		/* u */
	EditInsert,		/* v */
	EditInsert,		/* w */
	EditInsert,		/* x */
	EditInsert,		/* y */
	EditInsert,		/* z */
	EditInsert,		/* { */
	EditInsert,		/* | */
	EditInsert,		/* } */
	EditInsert,		/* ~ */
	EditDeleteChar,		/* DEL */
       
     }, 
    EscKeyTable[128] =
      {
	EditNop,		/* Null */
	EditNop,		/* control A */
	EditNop,		/* control B */
	EditNop,		/* control C */
	EditNop,		/* control D */
	EditNop,		/* control E */
	EditNop,		/* control F */
	EditBeep,		/* control G */
	EditDeleteChar,		/* control H */
	EditNop,		/* control I */
	EditNop,		/* control J */
	EditDeleteNextLine,	/* control K */
	EditNop,		/* control L */
	EditReleaseLine,	/* control M */
	EditNop,		/* control N */
	EditNop,		/* control O */
	EditNop,		/* control P */
	EditNop,		/* control Q */
	EditNop,		/* control R */
	EditNop,		/* control S */
	EditTransposeChar,	/* control T */
	EditDeleteLine,		/* control U */
	EditNop,		/* control V */
	EditDeleteWord,		/* control W */
	EditNop,		/* control X */
	EditNop,		/* control Y */
	EditNop,		/* control Z */
	       
	EditNop,		/* ESC */
	EditNop,		/* FS */
	EditNop,		/* GS */
	EditNop,		/* RS */
	EditNop,		/* US */
	
	EditInsert,		/* Space */
	EditInsert,		/* ! */
	EditInsert,		/* " */
	EditInsert,		/* # */
	EditInsert,		/* $ */
	EditInsert,		/* % */
	EditInsert,		/* & */
	EditInsert,		/* ' */
	EditInsert,		/* ( */
	EditInsert,		/* ) */
	EditInsert,		/* * */
	EditInsert,		/* + */
	EditInsert,		/* , */
	EditInsert,		/* - */
	EditInsert,		/* . */
	EditInsert,		/* / */
	EditInsert,		/* 0 */
	EditInsert,		/* 1 */
	EditInsert,		/* 2 */
	EditInsert,		/* 3 */
	EditInsert,		/* 4 */
	EditInsert,		/* 5 */
	EditInsert,		/* 6 */
	EditInsert,		/* 7 */
	EditInsert,		/* 8 */
	EditInsert,		/* 9 */
	EditInsert,		/* : */
	EditInsert,		/* ; */
	EditInsert,		/* < */
	EditInsert,		/* = */
	EditInsert,		/* > */
	EditInsert,		/* ? */

	EditInsert,		/* @ */
	EditInsert,		/* A */
	EditBackwardWord,	/* B */
	EditInsert,		/* C */
	EditDeleteNextWord,	/* D */
	EditInsert,		/* E */
	EditForwardWord,	/* F */
	EditInsert,		/* G */
	EditDeleteWord,		/* H */
	EditInsert,		/* I */
	EditInsert,		/* J */
	EditInsert,		/* K */
	EditInsert,		/* L */
	EditInsert,		/* M */
	EditInsert,		/* N */
	EditInsert,		/* O */
	EditInsert,		/* P */
	EditInsert,		/* Q */
	EditInsert,		/* R */
	EditInsert,		/* S */
	EditInsert,		/* T */
	EditInsert,		/* U */
	EditInsert,		/* V */
	EditInsert,		/* W */
	EditInsert,		/* X */
	EditInsert,		/* Y */
	EditInsert,		/* Z */
	EditEscape,		/* [ -- ANSI escape sequence */
	EditInsert,		/* \ */
	EditInsert,		/* ] */
	EditInsert,		/* ^ */
	EditInsert,		/* _ */

	EditInsert,		/* ` */
	EditInsert,		/* a */
	EditBackwardWord,	/* b */
	EditInsert,		/* c */
	EditDeleteNextWord,	/* d */
	EditInsert,		/* e */
	EditForwardWord,	/* f */
	EditInsert,		/* g */
	EditDeleteWord,		/* h */
	EditInsert,		/* i */
	EditInsert,		/* j */
	EditInsert,		/* k */
	EditInsert,		/* l */
	EditInsert,		/* m */
	EditInsert,		/* n */
	EditInsert,		/* o */
	EditInsert,		/* p */
	EditInsert,		/* q */
	EditInsert,		/* r */
	EditInsert,		/* s */
	EditInsert,		/* t */
	EditInsert,		/* u */
	EditInsert,		/* v */
	EditInsert,		/* w */
	EditInsert,		/* x */
	EditInsert,		/* y */
	EditInsert,		/* z */
	EditInsert,		/* { */
	EditInsert,		/* | */
	EditInsert,		/* } */
	EditInsert,		/* ~ */
	EditDeleteChar,		/* DEL */
      };



