/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1984			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * interp.h - Definitions for VGTS interpreter
 *
 * Craig Dunwoody June 1984
 */

#include <Vgtp.h>

enum InterpState
  {
  	/*
	 * state of the VGTS interpreter for each user
	 */
    NotThere,		/* user not created yet */
    Transparent,	/* just send chars to the pad */
    GetRequest,		/* after sync code, before request code */
    GetParams,		/* getting the scalar parameters */
    GetHalfParam,	/* get the low order half a parameter */
    GetLength,		/* get the length of the string (or escape code) */
    GetLength4,		/* get the hi order 8 of 32 bits of string length */
    GetLength3,		/* get the hi order 8 of 32 bits of string length */
    GetLength2,		/* get the middle 8 of 32 bits of string length */
    GetLength1,		/* get the low order 8 bits of the length */
    GetString,		/* getting a string */
    SkipString,		/* skipping a string because we ran out of memory */
    GetMenuLength,	/* getting string length in Pop up menu string */
    GetMenuString,	/* getting a PopUp menu string */
    GetMenuNumber,	/* getting a menu number */
    GetStringRotate	/* convert SDF_RASTER string to RowOrder format */
  };


struct InterpUser
  {
    enum InterpState state;	/* state this interpreter is in */
    enum VgtsRequest req;	/* the pending VGTS request */
    short vgt;			/* the pad we are going through */
    short arg[8];		/* scalar parameters */
    int count;			/* number of current parameter */
    int length;			/* string length */
    short menuCount;		/* count menu items */
    char *string;		/* the string we are forming */
    struct TtyPadRec *pad;	/* the pad pointer */
    union
      {
	PopUpEntry menu[16];	/* stores the pop-up menus */
	long work[6];		/* extra working storage */
      } u;
  };

extern BOOLEAN TransparentChar();
