/* The following definitions form an interface to the Sun-2 graphics library. */

#include <bitmaps.h>
#include <Vfont.h>
#include <framebuf.h> /* for GXinvert - grumble. */

extern MemRaster Sun2FrameBuffer;
extern VRaster Sun120Fb;

#define SUN2FbBase 0xEC0000 /*Address of Sun-2 framebuffer in Sun-2 (proper).*/
#define SUN3FbBase 0xFE20000/* Address of Sun-3 framebuffer */


/* Basic operations on the screen. */
#define gl_EnableScreen()		Sun2_EnableScreen()
#define gl_DisableScreen()		Sun2_DisableScreen()

/* Unary operations on rectangular regions. */
#define UnaryRasterOp(r, op)		UnaryOp2(r, op)
#define gl_BlackenRaster(r)		Sun2_BlackenRaster(r)
#define gl_WhitenRaster(r)		Sun2_WhitenRaster(r)
#define gl_InvertRaster(r) \
 { MemRaster m;	\
   SubRaster2(&m, &Sun2FrameBuffer, (r)->x, (r)->y, (r)->height, (r)->width);\
   UnaryRasterOp(&m, GXinvert); }

/* 0perations for drawing 16x16 stipple patterns in rectangular regions. */
#define gl_PutPattern(dst, pat)		Sun2_PutPattern(dst, pat)
#define gl_PaintPattern(dst, pat)	Sun2_PaintPattern(dst, pat)

/* Operations for drawing arbitrary rectangular rasters on the screen. */
#define gl_PutRaster(dst, src)		Sun2_PutRaster(dst, src)
#define gl_XorRaster(dst, src)		Sun2_XorRaster(dst, src)
#define gl_PaintRaster(dst, src)	Sun2_PaintRaster(dst, src)
#define gl_InvPaintRaster(dst, src)	Sun2_InvPaintRaster(dst, src)

/* Operations for copying rectangular rasters from the screen. */
#define gl_GetRaster(dst, src)		Sun2_GetRaster(dst, src)

/* Operations for copying rectangular regions from one part of the screen to
   another. */
#define gl_CopyRaster(dst, src)		Sun2_CopyRaster(dst, src)

/* Line drawing operations. */
#define gl_DrawLine(x,y,dx,dy)		Sun2_Line(x,y,dx,dy)

/* Text operations */
#define gl_WriteGeneralText(str,n,x,y,codes,bBox) \
  { FontEntry *fEntry = (FontEntry*)LookupFont(codes & 0xFF); \
    if (fEntry) WriteText2S(str,n,x,y,codes,fEntry->font,bBox); }
