/* The following definitions form an interface to the Sun-1 graphics library. */

#include <framebuf.h>
#include <confreg.h>

#define SUN2upgFbBase 0xFC0000/* Address of Sun-1 framebuffer in Sun-2(upg). */

/* The Sun-1 displays "0" as "black" and "1" as "white" (opposite to Sun-2),
 * so on the Sun-1 we invert patterns and rasters in transit to/from the
 * framebuffer.  For this purpose, we define new GXfunction codes below.
 *
 * Note: To be consistent, the GXfunction code for "gl_PutRaster()" and
 * "gl_GetRaster()" should be "GXcopyInverted" rather than "GXcopy".  However,
 * "GXcopyInverted" does not work correctly with "RasterGet()", so we use
 * "GXcopy" instead.  This does not cause any problems, since in the
 * VGTS "gl_PutRaster()" is used only in concert with "gl_GetRaster()", and
 * vice-versa.
 */
#define GXandInvPattern		(GXDEST & ~GXMASK)
#define GXcopyInvPattern	(~GXMASK)
#define GXorInv			(GXDEST | ~GXSOURCE)
#define GXxorInv		(GXDEST ^ ~GXSOURCE)
#define GXandInv		(GXDEST & ~GXSOURCE)


/* Basic operations on the screen. */
#define gl_EnableScreen()		GXcontrol = GXvideoEnable
#define gl_DisableScreen()		GXcontrol = 0

/* Unary operations on rectangular regions. */
#define gl_BlackenRaster(r)		{ GXfunction = GXclear; \
					  RasterFill(r); }
#define gl_WhitenRaster(r)		{ GXfunction = GXset; \
					  RasterFill(r); }
#define gl_InvertRaster(r)		{ GXfunction = GXinvert; \
					  RasterFill(r); }

/* 0perations for drawing 16x16 stipple patterns in rectangular regions. */
#define gl_PutPattern(dst, pat)		{ GXfunction = GXcopyInvPattern; \
					  RasterPattern(dst, pat); }
#define gl_PaintPattern(dst, pat)	{ GXfunction = GXandInvPattern; \
					  RasterPattern(dst, pat); }

/* Operations for drawing arbitrary rectangular rasters on the screen. */
#define gl_PutRaster(dst, src)		{ GXfunction = GXcopy; \
					  RasterPut(dst, src); }
#define gl_XorRaster(dst, src)		{ GXfunction = GXxor; \
					  RasterPut(dst, src); }
#define gl_PaintRaster(dst, src)	{ GXfunction = GXandInv; \
					  RasterPut(dst, src); }
#define gl_InvPaintRaster(dst, src)	{ GXfunction = GXorInv; \
					  RasterPut(dst, src); }

/* Operations for copying rectangular rasters from the screen. */
#define gl_GetRaster(dst, src)		{ GXfunction = GXcopy; \
					  RasterGet(dst, src); }

/* Operations for copying rectangular regions from one part of the screen to
   another. */
#define gl_CopyRaster(dst, src)		{ GXfunction = GXcopy; \
					  RasterCopy(dst, src); }

/* Line drawing operations. */
#define gl_DrawLine(x,y,dx,dy)		{ GXfunction = GXclear; \
					  GXwidth = 1; \
					  Line(x,y,dx,dy); }
/* Text operations */
#define gl_WriteGeneralText(str,n,x,y,codes,bBox)	\
  { FontEntry *LookupFont(), *fontp = LookupFont(codes & 0xFF); \
    if (fontp) WriteText_Sun100(str,n,x,y,codes,bBox);}
