/* The following definitions form an interface to the QVSS graphics library. */

#include <Vfont.h>
#include <bitbltops.h> /* for GXinvert - grumble. */

extern VRaster *WholeScreen;


/* Basic operations on the screen. */
#define gl_EnableScreen()	QvssEnable()
#define gl_DisableScreen()	QvssDisable()


/* Unary operations on rectangular regions. */
#define UnaryRasterOp(r, op)		UnaryOp2(r, op)
#define gl_BlackenRaster(r)	\
 { VRaster m; QvssRectangle(&m+1, r); RasterClear(&m+1); }
#define gl_WhitenRaster(r)	\
 { VRaster m; QvssRectangle(&m+1, r); RasterSet(&m+1); }
#define gl_InvertRaster(r)	\
 { VRaster m; QvssRectangle(&m+1, r); RasterInvert(&m+1); }

/* 0perations for drawing 16x16 stipple patterns in rectangular regions. */
#define gl_PutPattern(dst, pat)	{ VRaster __m; QvssRectangle(&__m+1, dst);\
  PatternOp(&__m+1, pat, (dst)->start.v, GXcopyInverted);}
#define gl_PaintPattern(dst, pat) { VRaster __m; QvssRectangle(&__m+1, dst);\
  PatternOp(&__m+1, pat, (dst)->start.v, GXpaintInverted);}

/* Operations for drawing arbitrary rectangular rasters on the screen. */
#define gl_PutRaster(dst, src) { VRaster _m; \
  QvssRectangle(&_m+1, dst); RasterOp(&_m+1, src, 12); }
#define gl_XorRaster(dst, src) { VRaster _m; \
  QvssRectangle(&_m+1, dst); RasterOp(&_m+1, src, 9); }
#define gl_PaintRaster(dst, src) { VRaster _m; \
  QvssRectangle(&_m+1, dst); RasterOp(&_m+1, src, 8); }
#define gl_InvPaintRaster(dst, src) { VRaster _m; \
  QvssRectangle(&_m+1, dst); RasterOp(&_m+1, src, 0xE); }

/* Operations for copying rectangular rasters from the screen. */
#define gl_GetRaster(dst, src) { VRaster _m; \
   QvssRectangle(&_m+1, src); RasterOp(dst, &_m+1, 12); }

/* Operations for copying rectangular regions from one part of the screen to
   another. -- apparently not needed */
/*** #define gl_CopyRaster(dst, src)		Sun2_CopyRaster(dst, src) ***/

/* Line drawing operations. */
#define gl_DrawLine(x,y,dx,dy)          Vax_Line(x,y,dx,dy)

/* Text operations */
#define gl_WriteGeneralText(str,n,x,y,codes,bBox) /* */
