# include <Vioprotocol.h>
# include "Vgts.h"
# include "sdf.h"
# include "vgt.h"
# include "splines.h"

/*
 *  This file contains DisplaySpline(), a routine which will take an
 *  item of type SPLINE and invoke the proper routine to display it.
 *
 *  Update History:
 *	March 1983 -- Written by David Kaelbling.
 */
    
    
/* Imports */
extern XYbrush();
extern XYpolygon();
extern XYfillPolygon();
extern XYspline();
extern XYfillSpline();
    
    
/* Exports */
extern DisplaySpline();
    
    
/*
 *  This routine will accept a pointer to an item and display it.
 */
 
DisplaySpline( item, dx, dy, view, clip, data )
	register SPLINE *item;
	short dx, dy;
	View *view;
	struct SubView *clip;
	unsigned char data;
  {
    register short i;
    register POINT *vert;
    
    /* AddItem should have verified that all data is valid */
    if (item->numvert == 0)
	return;
    else if (item->numvert == 1)
        item->order = 1;
    else if ((item->numvert == 2)  &&  !(item->closed))
	item->order = 2;
    vert = &(item->head);
    switch (item->order)
      {
	case 1:
	    for (i = 0;  i < item->numvert;  i++)
	      {
	        XYbrush( XcvtToScreen( vert[i].x + dx, view ),
			 YcvtToScreen( vert[i].y + dy, view ),
			 clip, item->nib );
	      }
	    break;
	
	case 2:
	    if (item->filled)
		XYfillPolygon(	item->pat, item->opaque, vert, 
				item->numvert, clip, view, dx, dy );
	    if (item->border)
	      {
		/* Magnified polygons are slow -- use splines */
		if ((view->zoom <= 0) && (item->numvert > 1))
		    XYpolygon( vert, item->numvert, (BOOLEAN) item->closed,
			clip, item->nib, view, dx, dy );
		else
		    XYspline( item->numvert, vert, item->order,
			(BOOLEAN) item->closed, clip, 
			item->nib, view, dx, dy );
	      }
	    break;
		    
	default:
	    if (item->filled)
		XYfillSpline( item->numvert, vert, item->order,
			item->pat, item->opaque, clip, view, dx, dy );
	    if (item->border)
		XYspline( item->numvert, vert, item->order,
			(BOOLEAN) item->closed, clip, 
			item->nib, view, dx, dy );
	    break;
      }
  }
