/* arc.h: data types relating to display of arcs and circles.  This is really
 * mixed up: Arc should be in sdf.h, Arcpoint should be in Vgts.h, and
 * Arcdata should be in Vgtp.h.  Sorry about that -- Kenneth
 */

/* The "mixed" type, used to represent slopes, is a signed, fixed-point
 * mixed number.  The upper 16 bits represent the integer part; the lower
 * 16 bits represent the fraction.  The MixedQuotient macro produces mixed
 * values.
 */
typedef int mixed;

/* line segment or arc */
typedef struct arcseg {
	struct arcseg *next;
	struct arcseg *link;
	function *advance;
	short xleft, xright; /* for fill-polyarc only */
	short x0, y0; /* always the endpoint with the lower y value */
	short x1, y1;
	short type, linked;

	short cx, cy;
	short x, y;   /* for fill-polyarc only */
	unsigned xsq, ysq; /* for fill-polyarc only */
	unsigned rsq;
	short r;
	}  Arc;

typedef Arc Seg;	/* synonym used where arcs or lines are expected */

/* A variant form of Seg, for straight segments.  We will cast to it when
 * we need the slope and xlo fields.  (Unions are so ugly to use!)
 */
struct lineseg {
	Seg *next;
	Seg *link;
	function *advance;
	short xleft, xright; /* same value in a lineseg */
	short x0, y0; /* always the endpoint with the lower y value */
	short x1, y1; /* we do not bother to set x1; slope implies it */
	short type, linked;

	mixed slope;
	short x;
	unsigned short xlo; /* together with x, makes one "mixed" value */
	};

/* data as stored in the display list */
typedef struct arcdata {
	short x, y;	/* starting point (in order given by client) */
	short cx, cy;	/* center (computed) */
	short r;	/* radius (computed) */
	short type;	/* type of arc or line (computed) */
	}  Arcdata;

/* data as initially specified by the user */
typedef struct arcpoint {
	short x, y;	/* starting point */
	short a;	/* angle through which it curves */
	}  Arcpoint;

/* types of segments used in polyarc computations */

#define LINE 1
#define VESTIGE 2	/* results from arcs of length <= 1 */

#define ARC 3
/* chopped arcs in the four quadrants */
#define ULARC 4
#define URARC 5
#define LRARC 6
#define LLARC 7

#define NOARC 0  /* clipped out entirely */

