#include <Vioprotocol.h>
#include <rasterops.h>
#include "Vgts.h"
#include "sdf.h"
#include "arc.h"
#include "vgt.h"


DrawArcs(arc, clip)
  register Seg *arc;
  struct SubView *clip;
  {
    for ( ; arc; arc=arc->next)
      {
	ClipArc(arc, clip);
	switch(arc->type)
	  {
	  case ULARC: DrawArcUL(arc);  break;
	  case URARC: DrawArcUR(arc);  break;
	  case LRARC: DrawArcLR(arc);  break;
	  case LLARC: DrawArcLL(arc);  break;
	  case NOARC: break;
	  }
      }
  }


CleanOutArcs(arclist)
  Seg *arclist;
  {
    register Seg *arc, *temp;

    arc = arclist;
    while(arc)
      {
	temp = arc->next;
	free(arc);
	arc = temp;
      }
  }


/* Clip an arc to the viewport.  The arc may vanish entirely, either because
 * its circle lies entirely outside, or because it skirts the corner, etc.
 * If it vanishes entirely, its type is set to NOARC.
 */
ClipArc(arc, clip)
  register Seg *arc;
  register struct SubView *clip;
  {
    register short x, y;

    /* gross y clipping */
    if ( arc->y1 < clip->ScreenYmin  /* above view entirely */
	 || arc->y0 > clip->ScreenYmax)  /* below view entirely */
      {
	arc->type = NOARC;
	return;
      }
    /* fine y clipping */
    if (arc->y0 < clip->ScreenYmin)
      {
	arc->y0 = clip->ScreenYmin;
	y = arc->cy - arc->y0;
	x = isqrt(arc->rsq - y*y);
	if (arc->type == URARC || arc->type == LRARC)
	    arc->x0 = arc->cx + x;
	else arc->x0 = arc->cx - x;
      }
    if (arc->y1 > clip->ScreenYmax)
      {
	arc->y1 = clip->ScreenYmax;
	y = arc->cy - arc->y1;
	x = isqrt(arc->rsq - y*y);
	if (arc->type == URARC || arc->type == LRARC)
	    arc->x1 = arc->cx + x;
	else arc->x1 = arc->cx - x;
      }

    /* x clipping */
    switch (arc->type)
      {
      case URARC:
      case LLARC:
	if (arc->x1 < clip->ScreenXmin || arc->x0 > clip->ScreenXmax) 
	  {
	    arc->type = NOARC;
	    break;
	  }
	if (arc->x0 < clip->ScreenXmin)
	  {
	    arc->x0 = clip->ScreenXmin;
	    x = arc->cx - arc->x0;
	    y = isqrt(arc->rsq - x*x);
	    if (arc->type == URARC)
		arc->y0 = arc->cy - y;
	    else arc->y0 = arc->cy + y;
	  }
	if (arc->x1 > clip->ScreenXmax)
	  {
	    arc->x1 = clip->ScreenXmax;
	    x = arc->x1 - arc->cx;
	    y = isqrt(arc->rsq - x*x);
	    if (arc->type == URARC)
		arc->y1 = arc->cy - y;
	    else arc->y1 = arc->cy + y;
	  }
	break;

      case ULARC:
      case LRARC:
	if (arc->x0 < clip->ScreenXmin || arc->x1 > clip->ScreenXmax) 
	  {
	    arc->type = NOARC;
	    break;
	  }
	if (arc->x0 > clip->ScreenXmax)
	  {
	    arc->x0 = clip->ScreenXmax;
	    x = arc->x0 - arc->cx;
	    y = isqrt(arc->rsq - x*x);
	    if (arc->type == ULARC)
		arc->y0 = arc->cy - y;
	    else arc->y0 = arc->cy + y;
	  }
	if (arc->x1 < clip->ScreenXmin)
	  {
	    arc->x1 = clip->ScreenXmin;
	    x = arc->cx - arc->x1;
	    y = isqrt(arc->rsq - x*x);
	    if (arc->type == ULARC)
		arc->y1 = arc->cy - y;
	    else arc->y1 = arc->cy + y;
	  }
	break;
      }

    /* cleanout in y: x clipping may have removed the whole thing */
    if (arc->y1 < clip->ScreenYmin || arc->y0 > clip->ScreenYmax) 
	arc->type = NOARC;
  }


DrawArcUR(arc)
  register Seg *arc;
  {
    register short x, y;
    register int xsq, ysq, rsq, savesq;
    short xlim, ylim;

    rsq = arc->rsq;
    x = arc->x0 - arc->cx;
    y = arc->y0 - arc->cy;
    ylim = arc->y1 - arc->cy;
    xlim = arc->x1 - arc->cx;
    savesq = xsq = x*x;
    ysq = y*y;

    while (y <= ylim)
      {
	while (xsq + ysq <= rsq && x <= xlim)
	  {
	    Plot(arc->cx + x, arc->cy + y);
	    savesq = xsq;
	    xsq += (x<<1) + 1;	  /* (x+1)**2 = x**2 + 2x + 1 */
	    x++;
	  }
	xsq = savesq;
	x--;  /* overshot by 1 pixel, back off and drop down */
	ysq += (y<<1) + 1;  /* y is negative, this DECREASES ysq */
	y++;
      }
  }


DrawArcUL(arc)
  register Seg *arc;
  {
    register short x, y;
    register int xsq, ysq, rsq, savesq;
    int xlim, ylim;

    rsq = arc->rsq;
    x = arc->x0 - arc->cx;  /* negative or zero */
    y = arc->y0 - arc->cy;
    ylim = arc->y1 - arc->cy;
    xlim = arc->x1 - arc->cx;
    savesq = xsq = x*x;
    ysq = y*y;

    while (y <= ylim)
      {
	while (xsq + ysq <= rsq && x >= xlim)
	  {
	    Plot(arc->cx + x, arc->cy + y);
	    savesq = xsq;
	    xsq += (-x<<1) + 1;	  /* (x-1)**2 = x**2 - 2x + 1 */
	    x--;
	  }
	xsq = savesq;
	x++;  /* overshot by 1 pixel, back off and drop down */
	ysq += (y<<1) + 1;  /* y is negative, this DECREASES ysq */
	y++;
      }
  }


DrawArcLR(arc)
  register Seg *arc;
  {
    register short x, y;
    register int xsq, ysq, rsq, savesq;
    int xlim, ylim;

    rsq = arc->rsq;
    x = arc->x0 - arc->cx;
    y = arc->y0 - arc->cy;
    xlim = arc->x1 - arc->cx;
    ylim = arc->y1 - arc->cy;
    xsq = x*x;
    savesq = ysq = y*y;

    while (x >= xlim)
      {
	while (xsq + ysq <= rsq && y <= ylim)
	  {
	    Plot(arc->cx + x, arc->cy + y);
	    savesq = ysq;
	    ysq += (y<<1) + 1;
	    y++;
	  }
	ysq = savesq;
	y--;  /* overshot by 1 pixel, back off and drop down */
	xsq += (-x<<1) + 1;
	x--;
      }
  }


DrawArcLL(arc)
  register Seg *arc;
  {
    register short x, y;
    register int xsq, ysq, rsq, savesq;
    int xlim, ylim;

    rsq = arc->rsq;
    x = arc->x0 - arc->cx;
    y = arc->y0 - arc->cy;
    xlim = arc->x1 - arc->cx;
    ylim = arc->y1 - arc->cy;
    xsq = x*x;
    savesq = ysq = y*y;

    while (x <= xlim)
      {
	while (xsq + ysq <= rsq && y <= ylim)
	  {
	    Plot(arc->cx + x, arc->cy + y);
	    savesq = ysq;
	    ysq += (y<<1) + 1;
	    y++;
	  }
	ysq = savesq;
	y--;  /* overshot by 1 pixel, back off and drop down */
	xsq += (x<<1) + 1;
	x++;
      }
  }


/* Integer square root.  Newton's algorithm, until the change between
 * iterations <= 1.  Then we hunt locally to find the right answer, which
 * is the square root with any fractional part truncated.  isqrt will loop
 * forever on a negative argument.
 */
int isqrt(n)
  register unsigned n;
  {
    register unsigned a, b;
    register int dif;

    a = n >> 1;
    dif = a;
    while (dif > 1)
      {
	b = (a>>1) + n / (a<<1);
	dif = a - b;
	a = b;
      }
    b = a * a;
    while (b < n)
      {
	b += (a<<1) + 1;
	a++;
      }
    if (b > n)
      {
	a--;
      }
    return(a);
  }
