#include <Venviron.h>
#include <Vteams.h>
#include <Vioprotocol.h>

extern InstanceId FileId();
extern ProcessId  FileServer();
extern SystemCode SetInstanceOwner();
extern char      *ErrorString();

extern int       QueryHosts();
extern ProcessId LoadProgram();
extern ProcessId Reply();

#define Concurrent	1

SystemCode StartTerminalAgent(netIn,netOut)
    File *netIn;
    File *netOut;
  {
    ProcessId     rtsPid;
    static char  *rtsArgs[] = { "rts", NULL };
    SelectionRec *rtsHost = NULL; 
    RootMessage   rtsRootMsg;
    static char  *rtsSearchPath = NULL;

    SystemCode error;

  /*
   *  There should be a call to QueryHosts() in here to set rtsHost;
   *  see doc/libc/pgmexec.mss and Vteams.h for details
   *
   */
    
    /* create the remote terminal server */
    rtsRootMsg.replycode = OK;
    rtsRootMsg.stdinserver  = FileServer(netIn);
    rtsRootMsg.stdoutserver = FileServer(netOut);
    rtsRootMsg.stderrserver = FileServer(netOut);
    rtsRootMsg.stdinfile  = FileId(netIn);
    rtsRootMsg.stdoutfile = FileId(netOut);
    rtsRootMsg.stderrfile = FileId(netOut);
    rtsRootMsg.rootflags = RELEASE_INPUT+RELEASE_OUTPUT+RELEASE_ERR;
			   /* +STDOUT_APPEND+STDERR_APPEND ? */
    rtsRootMsg.envblock = NULL;

    rtsPid = LoadProgram(rtsArgs, rtsHost, &rtsRootMsg,
			 rtsSearchPath,Concurrent,&error);
    if( error != OK )
      {
	fprintf(stderr,"***error loading rts: %s\r\n",
			ErrorString(error));
	return error;
      }

    /* give the exec ownership of its stdio */
    if( (error = SetInstanceOwner(FileServer(netIn),FileId(netIn),rtsPid))
			!= OK )
      {
	fprintf(stderr,"***unable to set owner of exec stdin: %s\r\n",
			ErrorString(error));
	return error;
      }
    if( (error = SetInstanceOwner(FileServer(netOut),FileId(netOut),rtsPid))
			!= OK )
      {
	fprintf(stderr,"***unable to set owner of exec stdout: %s\r\n",
			ErrorString(error));
	return error;
      }

    /* start the RTS */
    if( Reply(&rtsRootMsg,rtsPid) != rtsPid )
      {
	fprintf(stderr,"***error replying to rts (pid 0x%08x)\r\n",rtsPid);
	return INTERNAL_ERROR;
      }

    return OK;
  }
