/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/


/*
 * Primary internal include file.
 */

#include <Venviron.h>
#include <Vprocess.h>
#include "Vteams.h"
#include "Vservice.h"
#include <Vioprotocol.h>
#include <Vexceptions.h>
#include <Vnaming.h>
#include <Vdirectory.h>
#include <chars.h>
#include "lock.h"


#define FALSE 0
#define TRUE 1

/* Team priority values. */
#define DEFAULT_TEAM_PRIORITY	0x1000
#define REAL_TIME_PRIORITY1	(DEFAULT_TEAM_PRIORITY + 0x100)
#define REAL_TIME_PRIORITY2	(DEFAULT_TEAM_PRIORITY + 0x200)
#define REAL_TIME_PRIORITY3	(DEFAULT_TEAM_PRIORITY + 0x300)
#define REAL_TIME_PRIORITY4	(DEFAULT_TEAM_PRIORITY + 0x400)
#define RUNNING_TEAM_PRIORITY (DEFAULT_TEAM_PRIORITY + 0x500)
				/* Team priority of foreground team which has 
				   the current time slice. */
#define NONRUNNING_FG_TEAM_PRIORITY (DEFAULT_TEAM_PRIORITY + 0x600)
				/* Team priority of foreground teams which 
				   don't have the current time slice. */
#define NONRUNNING_BG_TEAM_PRIORITY (DEFAULT_TEAM_PRIORITY + 0x700)
				/* Team priority of background teams which 
				   don't have the current time slice. */
#define NONRUNNING_GUEST_TEAM_PRIORITY (DEFAULT_TEAM_PRIORITY + 0x800)
				/* Team priority of guest teams which 
				   don't have the current time slice. */
#define STOPPED_TEAM_PRIORITY 0xff00

#define TimerInterval 20	/* Interval at which the timer process wakes
				   up. */
#define DeadTeamNotice 2	/* Request code used by the validator process
				   to signal a team which has died or whose
				   owner had died to the teamserver. */
#define DeleteTeamEntryOnly 3	/* Request code used with TerminateSingleTeam
				   that causes only the TeamsEntry record
				   for a team and its descendants to be
				   removed.  No attempt is made to destroy 
				   the teams themselves.  This is used in 
				   conjunction with the DestroyHost operation 
				   for migration support. */
#define ValidationInterval 100	/* Interval at which teams are checked for
				   existence of themselves and their owners. */

#define MaxTeams 32		/* Maximum number of running teams that can be
				   handled by the team server. */
#define MaxArgsLength 128	/* Maximum size in bytes of the parameters
				   passed in the segment accompanying a load
				   request. */

#define DirectoryInstId	0x4321	/* Instance id used for directory */

#define PostDebugger "[public]debug"


typedef struct TeamsEntryType	/* Table entry record for a team that has
				   been loaded by the team server. 
				   *** NOTE *** Must be coordinated with 
				   TeamDescriptor types in Vdirectory.h */
  {
    struct TeamsEntryType *next;
    struct TeamsEntryType *prev;
    int inUse;			/* Used by the things that run through the
				   array of TeamsEntry records rather than
				   down the TeamsInUseList. */
    ProcessId ownerPid;		/* Pid of process owning the loaded team. 
				   0 if this entry is unused.  The
				   owner has the right to request destruction
				   of the loaded team.  Also, if the owner
				   dies, then all teams owned by him are 
				   killed.  Teams that are to be owned by
				   the "system" are given an ownerPid equal
				   to the pid of the teamserver. */
    ProcessId rootPid;		/* Pid of root process of loaded team. */
    char *name;			/* File name team was loaded from. */
    ProcessId loadServer;	/* Pid of file instance from which to load 
				   team. */
    InstanceId loadFile;	/* Fileid of file instance from which to load
				   team. */
    RootMessage debugRtMsg;	/* Root message for postmortem debugger. */
    unsigned short runPriority;	/* Team priority. */

    ProcessId migrationPid;	/* Used only for dummy teams created as 
				   part of migrating a logical host. 
				   Stores pid of team that will transfer into
				   this dummy team. */

  } TeamsEntry;


extern TeamsEntry Teams[MaxTeams];

extern TeamsEntry *TeamsFreeList;
				/* Stack of free team entry records. */
extern TeamsEntry *TeamsInUseList;
				/* Circular, doubly-linked list of active 
				   team entry records. */
extern int LockId;		/* Semaphore for locking the Teams array. */

extern TeamsEntry *InitStack(), *PopStack();
extern TeamsEntry *InitCList(), *FirstCList(), *LastCList(), *IterCList();


TeamsEntry *CurrentRunningTeam;	/* Ptr to the team which has
				   the current time slice. */
TeamsEntry *CurrentFgTeam;	/* Ptr to the local foreground team which 
				   would get the current time slice. */
TeamsEntry *CurrentBgTeam;	/* Ptr to the local background team which 
				   would get the current time slice. */
TeamsEntry *CurrentGuestTeam;	/* Ptr to the guest team which would get
				   the current time slice. */

ProcessId TeamServerPid;	/* Process id of main team server process. */

/* Naming support */
#define MAX_PATH_LENGTH 1024
