#include <Venviron.h>
#include <Vteams.h>
#include <Vquerykernel.h>

/*
 * returns status information of the host, if the status of the host
 * falls within the limits defined in the request message.
 */
int  UpdateIdleCounterTime = 6000 ; 
unsigned CurrentIdleTime = 0 ;
extern RootMessage *RootMsg ;
extern unsigned FirstEight, SecondEight ;


SystemCode CheckHostStatus(rmsg, reqPid)
    struct hostStatMsg *rmsg ;
    ProcessId reqPid ;
  {
    Message msg;
    QueryKernelRequest *request = (QueryKernelRequest *)msg;
    MachineConfigurationReply *mcReply = (MachineConfigurationReply *)msg;
    PeripheralConfigurationReply *pcReply = (PeripheralConfigurationReply *)msg;
    MemoryStatisticsReply *msReply = (MemoryStatisticsReply *)msg;
    KernelStatisticsReply *ksReply = (KernelStatisticsReply *)msg;

    static unsigned procType = 0 ;
    static unsigned proc, mach = 0 ;
    
    unsigned tmpProc, tmpProcType, tmpMach, idleTime, freemem ;
    int hostAvailability() ;


    /*
     *  check availability
     */
     
    if (rmsg->avail & AVAIL_RELEVANT)
      if (rmsg->avail & AVAILABLE)
        if (hostAvailability() <= 0)
	    return (DISCARD_REPLY) ;
	else
	    /* host is available as requested */ ;
	    
      else /* !(rmsg->avail & AVAILABLE) */
        if (hostAvailability() > 0)
	    return (DISCARD_REPLY) ;
	else
	    /* host is not available as requested */ ;
    rmsg->avail = ((hostAvailability() > 0) ? (char) AVAILABLE : 0) ; 



    /*
     *  check  processor and machine type
     */

    if (procType == 0)
      {
        QueryKernel(0, MACHINE_CONFIG, mcReply);
        if (mcReply->replycode != OK) return(mcReply->replycode) ;
        procType = (mcReply->processor & PROC_FAMILY) >> 4;
	proc = mcReply->processor ;
        mach = mcReply->machine ;
      }

    tmpProcType = rmsg->procMachType & PROC_FAMILY_FIELD ;

    if (tmpProcType != PROC_FAMILY_IRRELEVANT)
       if (tmpProcType != procType)
           return (DISCARD_REPLY) ;
    
    tmpProc = (rmsg->procMachType & PROC_TYPE_FIELD) >> PROC_TYPE_SHIFT ;
    if (tmpProc != PROC_TYPE_IRRELEVANT)
       if (tmpProc != proc)
           return(DISCARD_REPLY) ;

    tmpMach = (rmsg->procMachType & MACH_TYPE_FIELD) >> MACH_TYPE_SHIFT ;
    if (tmpMach != MACH_TYPE_IRRELEVANT)
       if (tmpMach != mach)
           return(DISCARD_REPLY) ;

    rmsg->procMachType = (proc << PROC_TYPE_SHIFT) |
    			 (mach << MACH_TYPE_SHIFT) | procType ;



    /*
     *  check idletime
     */

    idleTime = CurrentIdleTime ;
    if (idleTime < rmsg->minIdleTime)
        return (DISCARD_REPLY) ;
    if (rmsg->maxIdleTime != 0)
        if (idleTime > rmsg->maxIdleTime)
	    return (DISCARD_REPLY) ;
    rmsg->minIdleTime = idleTime ;


    /*
     *  check freeteams
     */

    QueryKernel(0, KERNEL_STATS, ksReply);
    if (ksReply->replycode != OK) 
      {
 	return(ksReply->replycode) ;
      }
    if (rmsg->freeTeams > ksReply->freeTds)
        return(DISCARD_REPLY) ;
    rmsg->freeTeams = ksReply->freeTds ;




    /*
     * then check freeprocs
     */

    if (rmsg->freeProcs > ksReply->freePds)
        return(DISCARD_REPLY) ;
    rmsg->freeProcs = ksReply->freePds ;




    /*
     *  check  free memory
     */


    QueryKernel(0, MEMORY_STATS, msReply);
    if (msReply->replycode != OK) return(msReply->replycode) ;
    freemem = msReply->unusedFastMemory + msReply->unusedSlowMemory ;
    if (freemem < rmsg->minFreeMem)
        return (DISCARD_REPLY) ;
    if (rmsg->maxFreeMem != 0)
        if (freemem > rmsg->maxFreeMem)
	    return (DISCARD_REPLY) ;
    rmsg->minFreeMem = freemem ;



    /*
     *  check  configuration
     */

       /* not implemented */



    /*
     *
     * We now know that we should reply to the call.
     * 
     */
    return(YOUR_LOOKING_FOR_ME) ;
  }





#define IdleProcess (GetPid(0,0) & 0xFFFF0000)



UpdateIdleTimeCount()
  {
    static unsigned oldIdleClicks, oldTotalClicks = 0;
    unsigned newTotalClicks, newIdleClicks;
    unsigned totalClicks, idleClicks;
    unsigned totalSecs;
    
    /* Do arithmetic in clicks and compute CurrentIdleTime as a percentage. */

    /* Find the total time taken since last time. */
    totalSecs = GetTime(&newTotalClicks);
    newTotalClicks += totalSecs * CLICKS_PER_SEC;
    if (newTotalClicks >= oldTotalClicks)
        totalClicks = newTotalClicks - oldTotalClicks;  
    else
        totalClicks = newTotalClicks + (0xFFFFFFFF - oldTotalClicks);

    /* Find the idle time in this interval. */
    QueryProcessorUsage (IdleProcess, &newIdleClicks, 0); 
    if (newIdleClicks >= oldIdleClicks)
        idleClicks = newIdleClicks - oldIdleClicks;
    else
        idleClicks = newIdleClicks + (0xFFFFFFFF - oldIdleClicks);

    CurrentIdleTime = 100 * idleClicks;
    CurrentIdleTime /= totalClicks;

    oldTotalClicks = newTotalClicks;
    oldIdleClicks = newIdleClicks;
  }
