/*
 * Lock/unlock macros for delimiting a critical region.
 * Assumes that the code in the critical region does not relinquish
 * the processor, e.g. by calling Send.
 */


/*
 * Lock:
 */

#define Lock(sem)		\
  {				\
    while (sem != 0)		\
      {				\
	Delay(0,1);		\
      }				\
    sem = 1;			\
  }


/*
 * Unlock:
 */

#define Unlock(sem) sem = 0;
