/********************************************************/
/*							*/
/*	       Simple Terminal Server			*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* pad.h - Pad routine redirections for TS line editing
 *
 *
 * Craig Dunwoody December 1983
 *
 */

/* purpose: to transform the use of pad routines into a
   standardized use of escape sequences.  */

extern short IsCadlinc;

typedef int TtyPadType;

#define TtyPadList (TtyPadType *)0


#define cursorPosUp		if (cursorPos.row > 0) cursorPos.row--
#define cursorPosDown		if (cursorPos.row < Nrows-1) cursorPos.row++
#define cursorPosLeft		if (cursorPos.col > 0) cursorPos.col--
#define cursorPosRight		if (cursorPos.col < Ncols) cursorPos.col++


#define	TtyPutString(s)	PadPutString(s, 0)


/* nullified operations */

#define PadCursorOn(p)
#define PadCursorOff(p)
#define PadRedraw(p)
#define DisplayInverse(p)
#define DisplayNormal(p)

#define Select(f,l)
#define Deselect()

#define TtyMessage(string)
