/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * keyboard.c - keyboard helper process 
 *
 * Bill Nowicki November 1982
 *
 * Terminal Server version, Kenneth Brooks, November 1983
 */

# include <Venviron.h>
# include <Vioprotocol.h>
# include <chars.h>
# include <Vgts.h>
# include "client.h"
# include <Vexec.h>

#include <stsio.h>

extern ProcessId StsPid, execserver;
extern int myexec;

KeyboardProcess()
  {
	/*
	 * read chars from the keyboard and send them to the Vgts
	 */
    IoRequest msg;
    register char c;
    ProcessId execpid, programpid;
    short status;

#ifdef RTS
    TelnetNegotiateInitialOptions();
#endif

    while (1)
      {
         c = GetCharacter();
	 if ( c == EOF && LastInputException() == BAD_BLOCK_NO )
	   {
	     ResynchInput();
	     c = GetCharacter();
	   }
	 msg.requestcode = (int)Keyboard;
	 msg.fileid = 0;
         msg.shortbuffer[0] = c;

	 /* the character control-^ (036) is the Telnet Escape character and
	  * is also used by the VGTS for switching between windows, and will
	  * probably be used extensively by the Virtual Terminal Server if
	  * such is ever built.  The Terminal Server uses only two escape
	  * sequences: ^^k for kill program and ^^x for new executive (which
	  * REPLACES the existing one.  For other such sequences, the
	  * Terminal Server forwards them on unchanged.
	  */
	 if (c==TELNET_ESCAPE)
	   {
	     char temp = GetCharacter();

	     switch ( (int)(temp & 0177) )
	       {
		case 'k':
		case 'K':
		  KillProgram(execserver, myexec);
		  break;

		case 'x':
		case 'X':
		  /* the ExecWatch process will automatically start a new one */
		  DeleteExec(execserver, myexec);
		  break;

		case 'i':
		case 'I':
		  QueryExec(execserver, myexec, &execpid, &programpid, &status);
		  if (status == EXEC_RUNNING && programpid != 0)
			ForceException(programpid);
		  break;

		default:	/* send it on to the TS uninterpreted */
		  Send( &msg, StsPid );
	 	  msg.requestcode = (int)Keyboard;
	          msg.shortbuffer[0] = temp;
		  msg.fileid = 0;
	       }
	   }
	 Send( &msg, StsPid);
      }
  }
