/********************************************************/
/*							*/
/*	      Simple Terminal Server			*/
/*							*/
/*		(C) COPYRIGHT 1984			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * interp.c - interpret escape sequences as commands
 *
 * Craig Dunwoody June 1984
 */

# include "edit.h"
# include "interp.h"

#include <stsio.h>

struct InterpUser *CreateInterp(user)
  {
      /*
       * Initialize the interpreter for the given user,
       * and return a pointer to it.
       */
    register struct InterpUser *u;
    
    u = (struct InterpUser *)malloc(sizeof(struct InterpUser));
    if (u) 
      {
	short length, width;
	
	PadGetSize(0, &length, &width);

	u->newlinesLeft = length - 1;
	u->pageLength = length - 1;
      }
     return(u);
  }



int InterpPutString( u, s, length, mode )
    register struct InterpUser *u;	/* pointer to Interp user structure */
    char *s;				/* pointer to string */
    int  length; 			/* string length */
    int  mode;				/* mode of cooking */
  {
  	/*
	 * Returns the ACTUAL number of bytes interpreted; may be less
	 * than length because the string may fill the pad in PageOutput mode.
	 */
    register int strCount = 0;
    register int strLength = length;
    register char c;
    short padLength, padWidth;

    BOOLEAN screenFull;

    if (u==NULL) return(0);
    PadGetSize(0, &padLength, &padWidth);
        
    while (strCount < strLength)
      {
	strCount++;
	if ( !TransparentChar(u, mode, padLength, padWidth, *s++) ) break;
      }

    FlushOutput();

    return(strCount);

  }



BOOLEAN TransparentChar(u, mode, padLength, padWidth, c)

    register struct InterpUser *u;	/* pointer to Interp user structure */
    int  mode;				/* mode of cooking */
    short padLength;			/* length of pad */
    short padWidth;			/* width of pad */
    char c;				/* the character */

  {

  	/*
	 * Send a character to the pad.  
	 * If PageOutput mode is on and pad becomes full, print continuation 
	 * prompt and return FALSE; else return TRUE.
	 * In any case update newlinesLeft.
	 */

    PutCharacter(c);
  
    if ( (c == '\n') && (mode & LF_Output) ) PutCharacter('\r');

    if (mode & PageOutput)
    
      {

	if ( (c == ESC) || (c == '\f') )
	    u->newlinesLeft = u->pageLength = padLength - 1;

	else if ( c == '\n' ) u->newlinesLeft--;

	if (u->newlinesLeft <= 0)
       
	    {
	      PutString("\r--Type <space> for next page--");
	      PadClearToEOL(0);
 	      return(FALSE);
      
	    }
      
      }
  
    return(TRUE);

  }
