/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* editbuf.h - Edit buffer declarations for VGTS text editing
 *
 *
 * Craig Dunwoody December 1983
 *
 */

#define CHUNKSIZE IO_MSG_BUFFER
#define CHUNKFILLPOINT ((CHUNKSIZE * 19)/20)
#define CHUNKSPLITPOINT ((CHUNKSIZE * 7)/10)


typedef struct chunk {
  struct chunk		*prev, *next;
  unsigned short	length;
  char			text[CHUNKSIZE];
  }  *Chunk;

typedef struct rowRec {
  Chunk chunk;
  char *cp;
  char endcol;	  /* in columns, not in bytes */
  char exists;	  /* there is text here */
  char continues; /* this row is a continuation */
  char continued; /* this row has a continuation */
  }  RowRec;

typedef struct mark {
  Chunk		chunk;
  char		*cp;
  }  Mark;

typedef struct markLink {
	Mark	*pmark;
	struct markLink *next;
	}  *MarkLink;

typedef struct pos {
  unsigned short row, col;
  }  Pos;


/*
 * A keytable is a variable-length linear array of one or more KeyTableEntries,
 * terminated by a KeytableEntry with an opCode value of KeyTableEnd.
 *
 * An incoming character is looked up in the current keytable by linearly
 * scanning the keytable for the first KeyTableEntry whose charCode field
 * matches the incoming character.  If such an entry is found, the operation
 * defined by the opCode field is performed, and the current keytable becomes
 * the keytable whose tableId equals the nextKeyTableId field of the matching
 * entry.
 *
 * There are three "special" opCode values:
 *
 *     KeyTableBeginRange   Indicates that the charCode field in this
 *			    keyTableEntry is the beginning of a "range" of
 *			    contiguous character codes terminated by the
 *			    charCode value of the next keyTableEntry.  If the
 *			    incoming character lies within this range, the
 *			    opCode of the next (range-terminating) keyTableEntry
 *			    is executed.  The nextKeyTableId field of a
 *			    range-starting KeyTableEntry is ignored.
 *
 *     KeyTableUseNext      Causes the character currently being interpreted to
 *			    be immediately re-interpreted using the next
 *			    keytable.
 *
 *     KeyTableEnd	    A KeyTableEntry with this opCode terminates the
 *			    keytable.
 *
 *
 * If no matching entry is found, no operation is performed, and the current
 * keytable becomes the keytable whose tableId equals the nextKeyTableId field
 * of the entry that terminates the keytable.
 */
 
typedef unsigned char	OpCode;
typedef unsigned char	KeyTableId;

typedef struct keyTableEntry

  {
    unsigned char	charCode;	/* Character code for this op       */
    OpCode		opCode;		/* The operation to be performed    */
    KeyTableId		nextKeyTableId;	/* The tableId of the next keytable */
  }  KeyTableEntry;


/*
 * A linked list of KeyTableRecs is maintained for each buffer in order to keep
 * track of all existing keytables for the buffer.  Associated with each of a
 * buffer's keytables is a unique identifier.
 */

typedef struct keyTableRec

  {
    struct keyTableRec	*next;		/* link */
    KeyTableId		keyTableId;	/* keytable identifier */
    KeyTableEntry	*keyTable;	/* the keytable itself */
  }  KeyTableRec;


typedef struct editBuffer {
	RowRec		*rows;
	MarkLink	markList;
	Mark		headmark, endmark, curmark, mousemark;
	Mark		promptmark, inputmark, backupmark;
	Pos		curpos, headpos;
	int		wishcol;
	short		selectionexists, displayed;
	KeyTableRec	*keyTableList, *curKeyTable;
	PopUpEntry	*menu;
	int		pagesToKeep;
	short		inFlags, outFlags;
	Chunk		prompt;
	}  EditBuffer;
