/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* client.h - VGTS Client multiplexor data structures
 *
 * Needs to have Vioprotocol defined first.
 *
 * Bill Nowicki April 1983
 *
 * Marvin Theimer, 6/83
 *	Added termPid to the ExecDescriptor structure.
 * Marvin Theimer, 7/83
 *	Removed cmdPid from the ExecDescriptor structure and made termPid
 *	now represent the break process set by SET_BREAK_PROCESS.
 * Tim Mann, 8/6/83
 *	Added a per-process area to the ExecDescriptor.

 * Kenneth Brooks, 11/83
 * 	Removed the ExecDescriptor business off into a separate exec server.
 *
 * Craig Dunwoody, 12/83
 *	Added editPrev field to the Event structure; added lineEditBuf to
 *	the Client structure, which makes it necessary to include "editbuf.h"
 *	to get the typedef for EditBuffer.
 */

#include "editbuf.h"	/* has typedef of EditBuffer, used in Client struct*/

# define TRUE 1
# define FALSE 0
# define BlockSize 512		/* buffer size for writes to a VGT */
# define MaxClients 16		/* Max clients that the vgts can handle. */
# define MaxEvents 32		/* Max number of queued events */
# define DirectoryInstance (MaxClients-1)
				/* special instance ID for directory I/O */

struct Event
  {
    struct Event *next;		/* link */
    struct Event *editPrev;	/* backward link */
    short requestcode, fileid;	/* for compatibility */
    short code;			/* kind of event */
    short x, y, buttons;	/* for mouse events - otherwise fileid etc. */
    char shortbuffer[IO_MSG_BUFFER];
    unsigned bytecount;		/* number of chars in the buffer */
  }
    EventTable[MaxEvents];

struct Client
	/*
	 * Descriptor for an applications client.  Contains queues
	 * of input characters and mouse
	 * clicks and flags for indicating the state of a client's
	 *  requests. 
	 */
  {
    int interp;			/* really a pointer to interp structure */
    ProcessId writerPid;	/* Process id of blocked writer, if any */
    ProcessId owner;		/* Delete it when this guy dies */
    ProcessId termPid;		/* pid of process to destroy on break input. */
    struct ReadRec *readQ;	/* queue of read requests */
    struct Event *eventQ;	/* event queue */
    struct Event *eventTail;
    EditBuffer *lineEditBuf;	/* buffer to build up a text line event */
    short isexec;		/* this info goes with view manager */
    short execid;
    short vgt;			/* pad for input to go to */
    short master;		/* master vgt if we are a slave */
    int block;			/* "block" for Vio protocol */
    int bytesWritten;		/* actual # bytes written when a write blocks */
    int lastBytesWritten;	/* # bytes written on the most recent attempt */
    MsgStruct reqMessage;	/* request msg, saved only if a write blocks */
    int mode;			/* mode bits (echo etc.) */
    int outputFlag;		/* see bit definitions below */
  };


struct ReadRec {
    struct ReadRec *next;
    ProcessId pid;		/* Process id of the client reading */
    int requestFlag;		/* see bit definitions below */
  };

	/*
	 * fillers for requestFlag of each client.
	 * The BlockBits are true if the pid is blocked awaiting
	 * reply on the given type of event.  
	 * SlaveReq means the client wants the first mouse event
	 * converted into characters.
	 */
# define Keyreq		1
# define Mousereq	2
# define BlockBits 	(Keyreq|Mousereq)
# define SlaveReq	4


	/*
	 * fillers for outputFlag of each client.
	 */

#define PageOutputShutdown	1	/* quit PageOutput when user clears*/


/*
 * special End-of-file event code
 */

# define EOFcode 0x8000

enum MessageKind
  { 
  	Timer, 			/* a timer for blinking the cursor */
	Keyboard, 		/* a character was typed */
	GraphicsHelperMsg	/* contains a grpahics event */
  };


extern struct Client ClientTable[];	/* the client table */

extern ProcessId VgtsPid;
