/*
 * V-System Pipe Server
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. May 1983.
 */

#include "pipe.h"

SystemCode Query_pipe( req, pid )
   QueryInstanceRequest *req; ProcessId pid;
  
    /* handle the "QUERY_INSTANCE" operation on a pipe */
    /* The nextblock field indicates the next block to be read
    /* and the last block field indicates the last block written
    /* for the writer and unknown for the reader. */
  {
    register CreateInstanceReply *reply = (CreateInstanceReply *) req;
    register PipeDesc *pipe;

    if( (pipe = Get_pipe(req->fileid) ) == NULL ) return( NOT_FOUND );

    reply->fileserver       = Me;
    reply->blocksize   = PIPE_BLOCK_SIZE;
    reply->filetype         = STREAM | VARIABLE_BLOCK
                        | ((req->fileid & 1) ? READABLE : WRITEABLE );

    reply->filelastblock = (req->fileid & 1) ? MAXBLOCKS : pipe->lastblock;
    reply->filelastbytes = PIPE_BLOCK_SIZE;
    reply->filenextblock = pipe->nextblock;

    return( OK );
  }

