/*
 * ND boot server -- V Sun version
 * A quick (?) and dirty program to act as a boot server using
 *   SMI's remote disk protocol
 *
 * Tim Mann 11/05/83
 */

/* Config parameters */
#define DEFAULT_BOOTFILE "[public]Vload10.d"
#define BLOCK_SIZE 512
#define BOOT_BUFFER_SIZE 32
#define PACKET_BUFFER_SIZE 2048

/* IP definitions */
#define IP_ETHERTYPE 0x800

typedef int Boolean;
typedef unsigned char Bit8;
typedef unsigned short Bit16;
typedef unsigned long Bit32;
typedef struct { Bit8 byte[6]; } Bit48;

#include "Vio.h"
#include "Vnet.h"
#include "iptcp.h"  /* stolen from MMT's internet server */

/* ND protocol definitions */
#define ND_PROTOCOL 77

typedef struct
  {
    Bit8 op;		/* operation code and flags */
    Bit8 minor;
    Bit8 err;
    Bit8 ver;
    Bit32 seqnum;	/* warning: overlayed structure only works */
    Bit32 blocknum;     /*   on big-endian machines */
    Bit32 bytecount;
    Bit32 residual;
    Bit32 offset;
    Bit32 ccount;
  }
NDHeader;

#define ND_READ 1
#define ND_WRITE 2
#define ND_ERROR 3
#define ND_OP_MASK 7
#define ND_WAIT_FLAG 010
#define ND_DONE_FLAG 020
#define ND_MAXDATA 1024

/* Ethernet packet defs */
typedef struct
  {
    Bit48 dest, source;
    Bit16 packetType;
  }
EthernetHeader;

typedef struct
  {
    EthernetHeader enh;
    struct iphdr iph;
    NDHeader ndh;
    Bit8 data;		/* starts here and goes on... */
  }
WholeShebang;

/* Buffers */
char BootBuffer[BOOT_BUFFER_SIZE][BLOCK_SIZE];
char PacketBuffer[PACKET_BUFFER_SIZE];

/* Globals */
Bit48 MyEthernetAddress;
Bit32 MyIpAddress;
int verbose = 0;

main(argc, argv)
    int argc;
    char *argv[];
  {
    char *bootfile = DEFAULT_BOOTFILE;
    int packetsize;

    printf("ND protocol boot server\r\n");

    InitEthernet();  /* sets MyEthernetAddress and MyIpAddress */

    /* Check for -v (verbose) flag */
    if (argc > 1 && argv[1][0] == '-' && argv[1][1] == 'v')
      {
	verbose++;
	argv++;
	argc--;
      }	

    /* First argument is the file name to boot from --
     * if not given, we use a default */
    if (argc > 1) bootfile = argv[1];
    if (verbose) printf("Loading bootfile\r\n");
    ReadBootfile(bootfile, &BootBuffer[2][0]);

    if (verbose) printf("Starting operation\r\n");
    while (1)
      {
	ReadEthernetPacket(PacketBuffer, &packetsize);  
	if (verbose) putchar('*');
	Flush(stdout);
	ProcessNDRequest(PacketBuffer, packetsize);
      }
  }



/* Process a Network Disk protocol request */
ProcessNDRequest(packet, size, out)
    WholeShebang *packet;
    int size;
    File *out;
  {
    /* Is this really an ND request? */
    if (packet->enh.packetType != IP_ETHERTYPE ||
	    packet->iph.version != CurrentInternetVersion ||
	    packet->iph.prot != ND_PROTOCOL)
	return;

    /* Print out received packet -- debugging aid */
    if (verbose) NDprint(&packet->ndh, size - sizeof(EthernetHeader) - 
	sizeof(struct iphdr), stdout);

    switch (packet->ndh.op & ND_OP_MASK)
      {
      case ND_READ: /* Read */
	DoNDRead(packet, size);
	break;

      case ND_WRITE: /* Write */
	if (verbose) printf("Attempted ND Write!\r\n");
	break;

      case ND_ERROR: /* Error */
	if (verbose) printf("Received ND Error Packet!\r\n");
	break;
      }
  }


/* Perform the requested read */
DoNDRead(req, size)
    register WholeShebang *req;
    int size;
  {
    register WholeShebang *reply = (WholeShebang *) req;

    reply->enh.dest = req->enh.source;
    reply->enh.source = MyEthernetAddress;

    reply->iph.tl = sizeof(struct iphdr) + sizeof(NDHeader) + ND_MAXDATA;
    reply->iph.dstAdr = req->iph.srcAdr;
    reply->iph.srcAdr = MyIpAddress;
    reply->iph.checksum = -1;  /* no checksum */

    reply->ndh.op = ND_READ+ND_WAIT_FLAG+ND_DONE_FLAG;
    reply->ndh.ccount = ND_MAXDATA;

    Copy(&reply->data, &BootBuffer[req->ndh.blocknum][0], ND_MAXDATA);

    if (verbose) NDprint(&reply->ndh, sizeof(NDHeader) + ND_MAXDATA, stdout);

    WriteEthernetPacket(reply, sizeof(EthernetHeader) + sizeof(struct iphdr)
	+ sizeof(NDHeader) + ND_MAXDATA);

  }    

/* Stolen from WIN's enwatch program: */
NDprint( buf, count, out)
  short *buf;
  int count;
  FILE *out;
  {
	/*
	 * Print out the weird SMI network disk protocol
	 */
    char *p;
    int op, minor, err, ver;

    if (count < 28) 
      {
	fprintf(out,"ND packet too short!:\r\n");
        Flush(out);
      }
    else 
      {
	fprintf( out, "ND ");
	op = *buf >> 8;
	switch (op&7)
	  {
	    case 1: fprintf(out,"Read ");	break;
	    case 2: fprintf(out,"Write ");	break;
	    case 3: fprintf(out,"Error ");	break;
	  }
	if (op&010) fprintf(out,"Wait ");
	if (op&020) fprintf(out,"Done ");
	minor = *buf++ & 0xFF;
	err = *buf >> 8;
	ver = *buf++ & 0xFF;
	fprintf(out,"minor 0%o err=0%o ver=%d\r\n", minor, err, ver );
	
	fprintf(out,"sequence number %d, n", GetInt(buf));
	buf += 2;
	fprintf(out,"block number %d, ", GetInt(buf));
	buf += 2;
	fprintf(out,"byte count %d\r\n", GetInt(buf));
	buf += 2;
	fprintf(out,"Residual %d ", GetInt(buf));
	buf += 2;
	fprintf(out,"offset %d ", GetInt(buf));
	buf += 2;
	fprintf(out,"in this packet %d\r\n", GetInt(buf));
	buf += 2;
      }
    fprintf(out,"%d bytes of data\r\n", count - 28 );
    Flush(out);
  }

GetInt(buf)
    register Bit8 *buf;
  {
    register int i;
    
    i = *buf++;
    i <<= 8;
    i |= *buf++;
    i <<= 8;
    i |= *buf++;
    i <<= 8;
    i |= *buf++;
    return(i);
  }

