/* Ethernet interface for SMI boot loader */

#include "Vioprotocol.h"
#define ENET10MEG
#include "Vethernet.h"

typedef unsigned char Bit8;
typedef unsigned short Bit16;
typedef unsigned long Bit32;
typedef struct { Bit8 byte[6]; } Bit48;

/* Globals */
Bit48 MyEthernetAddress;
Bit32 MyIpAddress;

/* Locals */
static File *etherInFile, *etherOutFile;

/* Do whatever is needed to initialize */
InitEthernet()
  {
    Message msg;
    register IoRequest *req = (IoRequest *) msg;
    register QueryEnetReply *reply = (QueryEnetReply *) msg;
    SystemCode error;
    char ips[20];
    int ipb[4];

    etherOutFile = Open("[device]ethernet", FCREATE+FBLOCK_MODE, &error);
    if (error != OK)
      {
	fprintf(stderr, "Error opening ethernet for output: %s\n",
		ErrorString(error));
	exit(1);
      }

    etherInFile = OpenFile(FileServer(etherOutFile), FileId(etherOutFile),
	FREAD+FBLOCK_MODE, &error);
    if (error != OK)
      {
	fprintf(stderr, "Error opening ethernet for input: %s\n",
		ErrorString(error));
	exit(1);
      }

    /* Determine our ethernet address */
    req->requestcode = QUERY_FILE;
    req->fileid = FileId(etherOutFile);
    Send(req, FileServer(etherOutFile));
    MyEthernetAddress = *(Bit48 *) &(reply->HostAddress.e10);
    if (req->requestcode != OK)
      {
	fprintf(stderr, "Error querying ethernet: %s\n",
		ErrorString(error));
	exit(1);
      }

    /* Find our internet address */
    error = QueryWorkstationConfig("ip-address", ips, 20);
    if (error != OK)
      {
	fprintf(stderr, "Error getting IP address: %s\n",
		ErrorString(error));
	exit(1);
      }
    if (sscanf(ips, "[%d.%d.%d.%d]", &ipb[0], &ipb[1], &ipb[2], &ipb[3]) != 4)
      {
	fprintf(stderr, "Error getting IP address: Bad format\n");
	exit(1);
      }
    MyIpAddress = (ipb[0]<<24) + (ipb[1]<<16) + (ipb[2]<<8) + ipb[3];
  }

/* Read an Ethernet packet, returning the size */
ReadEthernetPacket(buffer, size)
    char *buffer;
    int *size;
  {
    *size = Read(etherInFile, buffer, BlockSize(etherInFile));
    if (*size == 0) 
	fprintf(stderr, "Can't read ethernet packet: %s\n",
	    ErrorString(FileException(etherInFile)));
  }

/* Write an Ethernet packet */
WriteEthernetPacket(buffer, size)
    char *buffer;
    int size;
  {
    size = Write(etherOutFile, buffer, size);
    if (size == 0)
	fprintf(stderr, "Can't write ethernet packet: %s\n",
	    ErrorString(FileException(etherOutFile)));
  }


