/*			Memory File Server
 *
 * Reading and writing.
 */
   
#include <Vioprotocol.h>
#include "memserv.h"
  
SystemCode HandleReadInstance(req, id)
  register IoRequest *req;
  ProcessId id;
  {
    register IoReply	*reply = (IoReply *) req;
    SystemCode	r, rr;
    register Instance   *instance;
    Filedesc	*fd;
    unsigned	blk;
    int		count;
    mem		*readpoint;
    char	*reqptr;
 
    if((instance = GetInstance(req->fileid)) == NULL)
      {
	r = INVALID_FILE_ID;
	goto bottom;
      }
    if ((instance->type & READABLE) == 0)
      {
	r = NOT_READABLE;
	goto bottom;
      }
    if (req->bytecount == 0)
      {
	r = BAD_BYTE_COUNT;
	goto bottom;
      }
    if (instance->kind == DIRECTORY_INSTANCE)
      {
	return (ReadDirectory(req, id));
      }
	
    r = OK;
    fd = instance->fd;
    blk = req->blocknumber;
    reqptr = req->bufferptr;
    readpoint = fd->start + blk*BLOCKSIZE;
    if (debug) printf("read inst %d, block %d, %d bytes:  ",
	req->fileid, req->blocknumber, req->bytecount);

    /* set 'count' to the number of bytes that are possible to read. */
    count = req->bytecount;
    if (blk*BLOCKSIZE + count > fd->size)
      {
	count = fd->size - blk*BLOCKSIZE;
	if (count < 0) count = 0;
	r = END_OF_FILE;
      }
    if (debug) printf("returning %d bytes\n", count);
 
    /* send the data */
    if( count <= IO_MSG_BUFFER )
      {
	if (DifferentByteOrder(id))
	    ByteSwapLongCopy(readpoint, req->shortbuffer, count);
	else
	    Copy(req->shortbuffer, readpoint, count);
	reply->bytecount = count;
	reply->replycode = r; /* is either OK or END_OF_FILE */
	Reply( reply, id );
	r = NO_REPLY;
      }

    else if( req->requestcode != READ_AND_FORWARD &&
		count <= MAX_APPENDED_SEGMENT )
      {
	reply->bytecount = count;
	reply->replycode = r;  /* is either OK or END_OF_FILE */
	ReplyWithSegment( reply, id, readpoint, reqptr, count );
	r = NO_REPLY;
      }

    else  /* have to MoveTo */
      {
	if( (rr = MoveTo( id, reqptr, readpoint, count )) != OK )
	    r = rr;
	reply->bytecount = (r == OK || r == END_OF_FILE) ? count: 0;
	if( req->requestcode != READ_AND_FORWARD )
	  {
	    reply->replycode = r;
	    Reply( reply, id );
	    r = NO_REPLY;
	  }
	else
	  {
	    req->blocknumber = ((unsigned) r ) << 16;
	    Forward( req, id, Forwarder(id));
	    r = NO_REPLY;
	  }
      }
    return( r );  /* r should be NO_REPLY */

bottom: 
    if( r != NO_REPLY )  /* r should be NO_REPLY or an error code */
      {
	if( r == OK )
	  {
	    printf("After reading:  shouldn't be returning OK, count = %d\n",
			count);
 	    r = BAD_BYTE_COUNT;  /* r == OK => bytecount was zero */
	  }
	reply->bytecount = 0;
	if( req->requestcode != READ_AND_FORWARD )
	  {
	    reply->replycode = r;
	    Reply(reply, id);
	    r = NO_REPLY;
	  }
	else
	  {
	    req->blocknumber = ((unsigned) r ) << 16;  /* why?? */
	    Forward(req, id, Forwarder(id));
	    r = NO_REPLY;
	  }
      } /* end if r != NO_REPLY */

    return( r );
  }  /* HandleReadInstance */


/* Read the specified amount and then forward back requestor back
 * to original sender. Used for efficient program loading.
 */
SystemCode HandleReadAndForward(req, id )
  IoRequest	*req;
  ProcessId	id;
  {
    register IoReply  *reply = (IoReply *) req;

    if (Forwarder( id ) == 0)
      {
	reply->replycode = BAD_STATE;
	reply->bytecount = 0;
	Reply(reply, id);
	return( NO_REPLY );
      }
    else
      return(HandleReadInstance(req, id));
      /* just returns NO_REPLY: Forwarding was done in ReadInstance */

  } /* HandleReadAndForward */


SystemCode HandleWriteInstance(req, id, segbuf, segsize)
  register IoRequest	*req;
  ProcessId id;
  char *segbuf;
  unsigned  segsize;
  {
    IoReply		*reply = (IoReply *) req;
    register Instance	*instance;
    Filedesc		*fd;
    SystemCode		r;
    char		*reqptr;
    unsigned		blk, count, totalbytes = 0;
    int			overrun, addsize, newsize;
    mem			*writepoint;

    if( (instance = GetInstance(req->fileid)) == NULL )
      { 
	r = INVALID_FILE_ID;
	goto bottom;
      }
    if( (instance->type & WRITEABLE) == 0 )
      {
	r = NOT_WRITEABLE;
	goto bottom;
      }
	     
    fd = instance->fd;
    reqptr = req->bufferptr;
    count = req->bytecount;
    blk = req->blocknumber;
    if (debug) printf("write inst %d, block %d, %d bytes:  ",
	req->fileid, req->blocknumber, req->bytecount);

    writepoint = fd->start + blk*BLOCKSIZE;

    /* See if we exceed the current file size, if so, expand the file */
    overrun = blk + CountBlocks(count) - fd->nblocks;
    if (overrun > 0)  /* we need to expand the file's allocated space */
      {
	if (overrun > CLEARING)  addsize = overrun;
	else  addsize = CLEARING;
	if (!AddBlocksToFile(fd, addsize)) 
	  {
	    if (debug) printf("Failed to add %d blocks\n", addsize);
	    r = NO_SERVER_RESOURCES;
	    goto bottom;
	  }
      }

    /* somewhat separate issue: has the file's logical length increased? */
    newsize = blk*BLOCKSIZE + count;
    if (newsize > fd->size)  fd->size = newsize;
    if (debug) printf("new file size %d\n", fd->size);

    /* Now we have room, get the data - straight into the destination */
    if( count <= IO_MSG_BUFFER )
      {
	if (DifferentByteOrder(id))
	    ByteSwapLongCopy(req->shortbuffer, writepoint, count);
	else
	    Copy(writepoint, req->shortbuffer, count);
	totalbytes = count;
	r = OK;
      }
    else if (count <= segsize)
      {
	Copy(writepoint, segbuf, count);
	totalbytes = count;
	r = OK;
      }
    else
      {
	if( (r = MoveFrom( id, writepoint, reqptr, count )) != OK )
	    goto bottom;
	totalbytes += count;
      }

bottom:
    if( r != NO_REPLY )
      {
	reply->bytecount = ( r == OK ) ? totalbytes: 0;
	if( r != OK )  printf("ERROR on write: r = %s\n",ErrorString(r));
	reply->replycode = r;
	Reply( reply, id );
	r = NO_REPLY;
      }

    return( r );
  }
