/* Legalname: return 1 if filename is a legal file name else 0.
 * Requirements are that it should be >0 and <= MAX_NAME_LENGTH characters 
 * long, not contain any nonprinting characters, and not contain the '/' 
 * or ']' characters.
 */

#include <Vio.h>
#include <Vstorage.h>
#include "memserv.h"


Legalname( filename )
    char *filename;

  {
    int i;
    char c;

    i = 0;
    for( c = filename[i]; c != '\0' && c > ' ' && c < '\177'
	 && c != '/' && c != ']' ; c = filename[++i] )
      ;
    if( c == '\0' )
      return( 0 < i && i <= 32 );
    else
      return( 0 );
  
  }


/* test equality of strings */
int streq(a, b)
  register char *a, *b;
  {
    while (*a == *b && *a != 0)  a++, b++;
    if (*a == 0 && *b == 0) return(1);
    else return(0);
  }


/* Copy one or more blocks of memory upwards.  This routine deserves much
 * optimization, and has not gotten it yet.  Requires newtop > top.
 */
CopyUp(bottom, top, newtop)
  register unsigned *bottom, *top, *newtop;
  {
    while (top > bottom)  *--newtop = *--top;
  }


/* Copy one or more blocks of memory downwards.  Requires newbot < bottom. */
CopyDown(bottom, top, newbot)
  register unsigned *bottom, *top, *newbot;
  {
    while (bottom < top)  *newbot++ = *bottom++;
  }


/* Fatal error: print a message and quit. */
Fatal(string)
  char *string;
  {
    fprintf(stderr, "\nFatal error: %s\n", string);
    exit(1);
  }


/* The secret message type SET_DEBUG_MODE
 *   If unspecified[0] is 0, causes a debug dump of the file table to stdout.
 *   If unspecified[0] is 1, sets debug to the value in unspecified[1].
 *   Other values are reserved.
 */
HandleDebugAction(req, id)
  register MsgStruct *req;
  ProcessId id;
  {
    switch (req->unspecified[0])
      {
	case 0:
          DebugDump();
	  break;
	  
	case 1:
          debug = req->unspecified[1];
	  break;
	  
#ifdef TIME_NAMING
	case 2:
	  StartCpuTimer();
	  break;
	  
	case 3:
	  /* Warning: floating point format is machine-specific! */
	  StopCpuTimer(&req->unspecified[0], &req->unspecified[2]);
	  break;
#endif TIME_NAMING
      }
    return(OK);
  }


/* Dump of the file table, for debugging info */
DebugDump()
  {
    register Filedesc *fd;

    printf("\nFile table:\n");
    for (fd = fdtable; fd < fdtable + nfiles; fd++)
      {
	printf("   file %d: size %d (0x%x), start 0x%x, 0x%x blocks ",
		fd-fdtable, fd->size, fd->size, fd->start, fd->nblocks);
	if (fd->name) printf("(\"%s\")\n", fd->name);
	else printf("\n");
      }
    printf("\n");
    Flush(stdout);
  }
