/*			Memory File Server
 *
 * Instance descriptor handling.  Instance descriptors are a static table,
 * limited in size to MAX_INSTANCES.
 */

#include "memserv.h"

Instance insttable[MAX_INSTANCES] = {0};


/* Allocate a file instance descriptor and mark it as owned by 'owner'.
 *   Check for instances associated with non-existent processes.
 */
Instance *AllocInstance(owner)
  ProcessId owner;
  {
    register Instance 	*instance;

    /* Find a non-zero unused file instance identifier. */
    for (instance = insttable; instance < insttable + MAX_INSTANCES; instance++)
	if (!instance->owner || !ValidPid(instance->owner))
	  {
	    instance->owner = owner;
	    return( instance );
          }
    return(NULL);
  }


/* Return the instance descriptor pointer for the given fileid, provided
 * that instance's owner is still alive.
 */
Instance *GetInstance(fileid)
  unsigned fileid;
  {
    register Instance *instance;

    if (fileid > MAX_INSTANCES) return(NULL);
    instance = &insttable[fileid];

    if (instance->owner && ValidPid(instance->owner))  return(instance);
    else
      {
	instance->owner = 0;  /* make this instance empty */
	return(NULL);
      }
  }


/* Find an instance of the specified file, or return NULL if none */
Instance *FindInstance(fd)
  register Filedesc *fd;
  {
    register Instance *instance;

    for (instance = insttable; instance < insttable + MAX_INSTANCES; instance++)
	if (instance->fd == fd) return (instance);
    return(NULL);
  }
