/************************************************************************/
/*		        (C) COPYRIGHT 1985,1986				*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * stats.h - manifests for internetserver statistics gathering.
 */

#define False 0
#define True 1
#define Boolean int

/*
 * Message type definitions.
 */

#define StatsMessage	5 | SEGMENT_PRESENT
				/* Main stats msg type - must not
				   conflict with defs in net.h */

				/* Statistics message subtypes */
#define StatsOnTcpConnection	10
#define StatsOnInternetServer	11
#define StatsTellMeStatsGroup	12
#define StatsPeriodicEnable	13
#define StatsGlobalInquiry	14


#define CleanupTimerInterval 500/* Timing interval for CleanupTimer -
				   (in clicks) */
#define C_StatsSendInterval 180
				/* Multiple of CleanupTimerInterval.  Rate
				   at which statistics messages are sent
				   (if stats collection is enabled) */ 
				/* 180 => every 15 minutes (based on 500) */
#define C_StatsEnableInterval 24
				/* Multiple of CleanupTimerInterval.  Rate
				   at which statistics enable msgs must be
				   received from stats process before the
				   automatic sending of stats shuts off */
				/* 24 => every 125 seconds (based on 500) */


				/* Code to represent each stats msg type */
#define TcpStatsMsgCode 	398
#define GlobalStatsMsgCode 	399


typedef long TcpStatsMsg[25];	/* A Tcp statistics message */
typedef long GlobalStatsMsg[25];/* Global (to internetserver) stats msg */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;
    InstanceId		fileid;
#else LITTLE_ENDIAN
    InstanceId		fileid;
    SystemCode		requestcode;
#endif LITTLE_ENDIAN
    ProcessId		pid;
    int 		opcode;
    int			parm1;
    int			filler[2];
    char		*bufferptr;
    unsigned		bytecount;
  } InternetStatsRequest;


typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		replycode;
    InstanceId		fill;
#else LITTLE_ENDIAN
    InstanceId		fill;
    SystemCode		replycode;
#endif LITTLE_ENDIAN
    ProcessId		pid;
    int			filler[4];
    char		*bufferptr;
    unsigned		bytecount;
  } InternetStatsReply;


