/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Internetserver routines for queueing.
 */

#include "net.h"
#include "internet.h"


/*
 * InitSafeQueue:
 */

InitSafeQueue(q, ringBufs)
    RingQueue *q;
    RingBufRec ringBufs[];
  {
    int i;

    for (i = 1; i < MAX_RING_BUFS; i++)
      {
	ringBufs[i].pkt = Null;
	ringBufs[i].next = &(ringBufs[i-1]);
      }
    ringBufs[0].pkt = Null;
    ringBufs[0].next = &(ringBufs[MAX_RING_BUFS - 1]);
    q->head = &(ringBufs[0]);
    q->tail = q->head;
  }


/*
 * EnQueueSafe:
 */

Boolean EnQueueSafe(pkt, q)
    PktBuf pkt;
    RingQueue *q;
  {
    if (q->tail->next->pkt)
	return(False);
    else
      {
	q->tail = q->tail->next;
	q->tail->pkt = pkt;
	return(True);
      }
  }


/*
 * DeQueueSafe:
 */

PktBuf DeQueueSafe(q)
    RingQueue *q;
  {
    PktBuf pkt;

    if (q->head->next->pkt)
      {
        q->head = q->head->next;
	pkt = q->head->pkt;
	q->head->pkt = Null;
	return(pkt);
      }
    else
	return(Null);
  }




/*** ROUTINES RELATING TO UNBOUNDED QUEUEING ***/


/*
 * InitQueue:
 */

InitQueue(q)
    Queue *q;
  {
    q->head = NULL;
    q->tail = NULL;
  }


/*
 * EnQueue:
 */

EnQueue(q, rec)
    Queue *q;
    PktBuf rec;
  {
    rec->next = NULL;
    if (q->head == NULL)
        q->head = rec;
    else
        q->tail->next = rec;
    q->tail = rec;
  }


/*
 * DeQueueMiddle: remove record in middle of queue (after indicated rec)
 */

PktBuf DeQueueMiddle(q, rec)
    Queue *q;
    PktBuf rec;
  {
    PktBuf p;
    p = rec->next;
    if (p != NULL)
      {
	rec->next = p->next;
	p->next = NULL;
	if (p == q->tail)
	    q->tail = rec;
      }
    return(p);
  }

/*
 * DeQueue:
 */

PktBuf DeQueue(q)
    Queue *q;
  {
    PktBuf rec;

    if (q->head == NULL)
        rec = NULL;
    else
      {
        rec = q->head;
	q->head = q->head->next;
	rec->next = NULL;
	if (q->head == NULL)
	    q->tail = NULL;
      }
    return(rec);
  }
