/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Include file for multi-protocol definitions.
 */

#define NumProtocols 3		/* Number of protocols being supported. */
#define NumPnetProtocols 2	/* Number of protocols seen at the physical
				   network level. */

/* Indices of the externally visible protocols.  Note the relationship to
 * the quantities IPtype, TCPtype, ICMPtype and so on in Vnet.h: these
 * are *external* identifiers, whereas the following are for *internal*
 * use (primarily efficient mapping into protocol tables).
 */
#define IpProt 0
#define TcpProt 1
#define IcmpProt 2

/*
 * Indices of the network level protocols.
 */
#define IpNetProt 0
#define ArpNetProt 1

#define IpEtherType10Mb 0x800	/* Ethernet packet type for 10Mb
				   Internet packets. */
#define IpEtherType3Mb 01001	/* Ethernet packet type for 3Mb
				   Internet packets. */
#define ArpEtherType 0x806	/* Ethernet packet type for ARP Internet
				   packets. */


struct FuncBlock		/* Function table structure */
  {
    int (*InitProtocol) ();
    SystemCode (*CreateConnection) ();
    SystemCode (*NQueryProtocol) ();
    int (*NextTimeout) ();
  };

struct PnetBlock		/* Physical network protocol table record. */
  {
    unsigned prot;		/* Ethernet protocol type. */
    int active;			/* True if a network connection is active for
				   this protocol. */
    int (*initNetProt) ();	/* Initialization routine for this protocol.
				   */
    int (*rcv) ();		/* Receiving routine for this protocol. */
  };

extern struct PnetBlock PnetTable[];
