/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Module for initializing all internet server
 * parameters which are tunable.
 */


#include "net.h"
#include "internet.h"


/*
 * General InternetServer parameters
 */

#define C_BufAllocNum 10	/* Number of buffers to allocate from free
				   memory when packet free list is empty. */
#define C_BufAllocMax 50	/* Maximum number of buffers on packet free
				   list before some are returned back to free
				   memory. */
#define C_MaxBufAllocNum 100	/* Maximum number of packet buffers allowed
				   in the whole system. */
#define C_MaxBufAllocSaveQ 90   /* Maximum number of packet buffers in use
				   before disabling save queue optimization /*


/*
 * IP parameters
 */

#define C_ReassemblyTimeoutLen 100
				/* Duration of timeout for reassembly of
				   packets in clicks. */


/*
 * TCP parameters
 */

#define C_RcvWindowSize 1000	/* Receive window size */ 
				/* 1000 */
#define C_RcvWindowCutoff 500	/* Reduction window size cutoff point */ 
				/* 500 */
/*
 * Timeout lengths in clicks.
 */
#define C_LenRetransTimeout 100	/* Initial retransmission timeout value. */
				/* 100 */
#define C_LenTmeWaitTimeout MSL2 
#define C_LenAckTimeout 40	/* 40 */
#define C_LenSndWndTimeout 500	/* 500 */

#define C_MaxSynRetransTimeouts 4
				/* Number of times to retransmit a syn packet
				   before giving up and closing the
				   connection. */
#define C_MaxLenRetransTimeout 500
				/* Largest starting value of the packet
				   retransmit timer (averaged over recent
				   packet delays) */
				/* 500 */
#define C_MaxRetransTimeoutClicks 10000
				/* Elapsed number of clicks from when
				   packet is first retransmitted to when
				   we give up and close the connection */
#define C_MSL 4000		/* Maximum Segment Lifetime in clicks. */
#define C_MSL2 8000		/* 2 * MSL */



InitParms()
  {
    /*
     * General Internetserver parameters
     */
    BufAllocNum = C_BufAllocNum;
    BufAllocMax = C_BufAllocMax;
    MaxBufAllocNum = C_MaxBufAllocNum;
    MaxBufAllocSaveQ = C_MaxBufAllocSaveQ;
    
    /*
     * IP parameters
     */
    ReassemblyTimeoutLen = C_ReassemblyTimeoutLen;
    
    /*
     * TCP parameters
     */
    MSL = C_MSL;
    MSL2 = C_MSL2;		/* This defn. must come before the
				   TmeWaitTimeout one because that one uses
				   this one! */
    RcvWindowSize = C_RcvWindowSize;
    RcvWindowCutoff = C_RcvWindowCutoff;
    LenRetransTimeout = C_LenRetransTimeout;
    LenTmeWaitTimeout = C_LenTmeWaitTimeout;
    LenAckTimeout = C_LenAckTimeout;
    LenSndWndTimeout = C_LenSndWndTimeout;
    MaxSynRetransTimeouts = C_MaxSynRetransTimeouts;
    MaxLenRetransTimeout = C_MaxLenRetransTimeout;
    MaxRetransTimeoutClicks = C_MaxRetransTimeoutClicks;
    TcpRetransBackoff[0] = 1.0;
    TcpRetransBackoff[1] = 1.5;
    TcpRetransBackoff[2] = 2.0;
    TcpRetransBackoff[3] = 3.0;
    TcpRetransBackoff[4] = 4.0;
    TcpRetransBackoff[5] = 6.0;
    TcpRetransBackoff[6] = 8.0;
    TcpRetransBackoff[7] = 10.0;
    TcpRetransBackoff[8] = 16.0;
    TcpRetransBackoff[9] = 32.0;
    AllocBusyWait = 0;
  }
