/************************************************************************/
/*		        (C) COPYRIGHT 1985,1986				*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * inquery - InterNet QUERY program for inspection of internet server
 *    internal data structures and debugging.
 *
 * Created: 13-Feb-86				Author: Bruce L Hitson
 */

#include "version.h"
#include "Vioprotocol.h"
#include "net.h"
#include "inquery.h"

/* Forward declarations */
ProcessId FindServer();

/* Globals */
ProcessId qPid;				/* Replier to queries */

main()
  {
    int parm1,req,tmp;
    char c,c2;				/* Command character */

    qPid = FindServer();		/* Find local internetserver */
    if (qPid != 0)
	SendRequest(InqueryMessage,'V',0);

    while(1)
      {
	Resynch(stdout);
	printf("\n[%s] inquery command: ",VERSION);
	if (scanf("%1s",&c) == EOF) break;
	req = InqueryMessage;
	switch(c)
	  {
	    case 'R':		/* (re)attach to (different) internetserver */
	      {
		printf("   Enter hex pid (or 0 for local) : ");
		scanf("%x",&qPid);
		if (qPid)
		  {
		    printf("   ...looking for pid 0x%x...\n");
		    SendRequest(req,'V',0);
		  }
		else
		  {
	            qPid = FindServer();
		    if (qPid != 0)
			SendRequest(InqueryMessage,'V',0);
		  }
		break;
	      }

	    case 'S':		/* Statistics interval change inspect */
	      {
		printf("   Statistics periodic send interval in multiples of");
		printf("      5 seconds (i.e., 2=>10sec; or -1 to inspect): ");
		scanf("%d",&tmp);
		SendRequest(req,'S',tmp);
		break;
	      }

	    case 'A':		/* Attach to internet server I/O stream */
	      {
		printf("   Attach to debug I/O stream - confirm [y/n]:");
		scanf("%1s",&c2);
		if (c2 != 'y') 
		  {
		    printf("   ...not confirmed\n");
		    continue;
		  }
		SendRequest(req,'A',0);
		break;
	      }

	    case 'U':		/* Unattach from internet server I/O stream */
	      {
		printf("   Unattach from debug I/O stream - confirm [yn]:");
		scanf("%1s",&c2);
		if (c2 != 'y') 
		  {
		    printf("   ...not confirmed\n");
		    continue;
		  }
		SendRequest(req,'d',0);	/* Turn off debug I/O first */
		SendRequest(req,'U',0);		
		break;
	      }

	    case 'Q':		/* Quit (exit) the inquery program */
	      {
		printf("...exiting program...\n");
		exit(0);
		break;
	      }

	    case 'I':		/* Commands taking numeric argument */
	    case 'O':
	    case 'k':
	    case 'p':
	    case 'd':
	      {
		if (c == 'd')
		    printf("  How verbose? (-1=inspect,0=quiet,9=blabber): ");
		else if (c == 'I' || c == 'O')
		  {
		    c == 'I' ? printf("In") : printf("Out");
		    printf("put packet error rate (inspect/change)\n");
		    printf("  (-1=>inspect, 0=>infinite): 1 error per ");
		  }
		else
		    printf("  Enter connection instance index:  ");
		scanf("\n%d",&parm1);
		/* Fall through to send the request */
	      }

	    default:
	      {
	        if (c == '?')
		  {
		    printf("*** Commands local to inquery process ***\n");
		    printf("\tR - reestablish internetserver connection\n");
		    printf("\tQ - quit from inquery program\n");
		    printf("\t? - print help information\n");
		    printf("*** Commands known to internetserver ***\n");
		    /* Fall through to get remote help too */
		  }
		if (c == 'x')
		  {
		    printf("  Kill the internetserver?  confirm (y/n): ");
		    scanf("%1s",&c2);
		    if (c2 != 'y') 
		      {
			printf("   ...not confirmed\n");
			continue;
		      }
		    req = NetSuicide;
		  }
		/* Just forward it on to the internetserver */
		SendRequest(req,c,parm1);
		break;
	      }
	  }
      }
  }


/*
 * FindServer:
 * Essentially GetPid() with extra debug information.
 */

ProcessId FindServer()
  {
    ProcessId pid;

    pid = GetPid(INTERNET_SERVER, LOCAL_PID);
    if (pid == 0)
        printf("Can't find local internetserver\n");
    else
      {
        printf("Found local server, pid = 0x%x\n",pid);
      }
    return(pid);
  }

    
/*
 * SendRequest:
 * Compose a request and send it to the server.
 */

SendRequest(rcode,c,p1)
    int rcode;
    char c;
    int p1;
  {
    Message msg;				 /* General purpose message */
    InqueryRequest *req = (InqueryRequest *) msg;/* General request */
    InqueryReply *rep = (InqueryReply *) msg;	 /* General reply */

    req->requestcode = rcode;
    req->opcode = c;
    req->parm1 = p1;
    req->fileserver = stdout->fileserver;
    req->fileid = stdout->fileid;
    qPid = Send(msg, qPid);	  		/* in case of forwarding */
    if (rep->replycode != OK)
      {
	printf("  [Internetserver returns '%s']\n",
	    ErrorString(rep->replycode));
      }
  }
