/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * directory.c - context directory support for ikc gateway+internetserver
 *
 * Bruce L. Hitson - October 1984
 *
 */

#include <Vioprotocol.h>
#include <Vdirectory.h>
#include "net.h"
#include "internet.h"

extern ProcessId InternetServerPid;

static InternetDescriptor d;

HandleDirectoryCreate(msg, sender)
    register CreateInstanceReply *msg;
    register ProcessId sender;
  {
    if (InternetDebug > 3) printf("Opening context directory...\n");
    if (NetInstTable[DirectoryInstance].inUse) 
      {
	msg->replycode = BUSY;
      }
    else
      {
	NetInstTable[DirectoryInstance].inUse = READ_INST;
	NetInstTable[DirectoryInstance].filenextblock = 0;
	NetInstTable[DirectoryInstance].ownerPid = sender;
	((QueryInstanceRequest *)msg)->fileid = DirectoryFileId;
	msg->replycode = QueryInstance(msg);
      }
    return;
  }


HandleDirectoryRelease(msg)
    register IoReply *msg;
  {
    if (InternetDebug > 3) printf("...closing context directory\n");
    NetInstTable[DirectoryInstance].inUse = 0;
    msg->replycode = OK;
    return;
  }


HandleDirectoryRead(msg, pid)
    register IoRequest *msg; 
    register ProcessId pid;
  {
    struct NetInstDescr *ni;

    if (msg->blocknumber >= MAX_NET_INST)
      {
	msg->requestcode = END_OF_FILE;
        msg->bytecount = 0;
	return;
      }
    if (InternetDebug > 8)
	printf("Reading descriptor %d\n", msg->blocknumber);
    if (msg->bytecount != sizeof( InternetDescriptor ))
      {
	msg->requestcode = BAD_BYTE_COUNT;
        msg->bytecount = 0;
	return;
      }
    ni = &NetInstTable[msg->blocknumber];
    if (ni->inUse == 0)
	d.descriptortype = EMPTY_DESCRIPTOR;
    else
      {
	d.descriptortype = INTERNET_DESCRIPTOR;
	d.addr1 = 0;
	d.addr2 = 0;
	switch(ni->prot)
	  {
	    case TcpProt:
		strcpy(d.name, "Tcp");
		d.typeInternet = TCPtype;
		d.addr1 = LocalIpHost;
		d.addr2 = ((TcpTcbPtr) ni->tcbId)->foreignSocket.host;
		break;
	    case IpProt:
		strcpy(d.name, "Ip");
		d.typeInternet = IPtype;
		d.addr1 = LocalIpHost;
		break;
	    case IcmpProt:
		strcpy(d.name, "Icmp");
		d.typeInternet = ICMPtype;
		break;
	    default:
		strcpy(d.name, "Unknown");
		d.typeInternet = -1;		/* Invalid/unknown type */
		break;
	  }
      }

    if (DifferentByteOrder(pid))
      {
	if (d.descriptortype == INTERNET_DESCRIPTOR)
	    ByteSwapInternetDescriptor(&d);
	else if (d.descriptortype == EMPTY_DESCRIPTOR)
	    ByteSwapEmptyDescriptor(&d);
      }
    msg->requestcode = MoveTo(pid, msg->bufferptr, &d, msg->bytecount);
    if (msg->requestcode != OK) msg->bytecount = 0;
  }
