/************************************************************************/
/*		   (C) COPYRIGHT 1983,1984,1985,1986			*/
/*                         BOARD OF TRUSTEES				*/
/*                 LELAND STANFORD JUNIOR UNIVERSITY			*/
/*                    STANFORD, CA. 94305, U.S.A.			*/
/************************************************************************/

/*
 * Internetserver routines for buffer management.
 */

#include "net.h"
#include "internet.h"


PktBuf PacketFreeList;		/* Packet buffer free list header. */
int NumAllocCalls;		/* Number of buffers allocated */
int NumDeallocCalls;		/* Number of buffers deallocated */


/*
 * BufSanityCheck:
 *   Check to see that buffer counts are OK.
 */

BufSanityCheck()
  {
    int error = 1;

    if ((TotalBufferCount < 0) ||
        (FreeBufferCount < 0) ||
        (FreeBufferCount > TotalBufferCount))
      {
	printf("*** BufSanityCheck fails! ***\n");
	printf("\tTotalBufferCount = %d\n",TotalBufferCount);
	printf("\tFreeBufferCount  = %d\n",FreeBufferCount);
	PauseInternetServer("buffer insanity");
      }
  }



/*
 *  InitBufMgr:
 *  Initialise the buffer manager data structures.
 */

InitBufMgr ()
  {
    PacketFreeList = NULL;
    FreeBufferCount = 0;
    TotalBufferCount = 0;
    NumAllocCalls = NumDeallocCalls = 0;
  }



/*
 *  AllocBuf:
 *    Allocate a buffer (if available), and return a pointer to it.
 *    If no buffers available, return NULL.
 */

PktBuf AllocBuf()
  {
    PktBuf packet;
    int i;

    /* BufSanityCheck(); */

    AcquireGlobalSpinLock(BufferLock);
    if (PacketFreeList == NULL)
      {
	for (i = 0; i < BufAllocNum; i++)
	  {
	    if (TotalBufferCount > MaxBufAllocNum)
		break;
	    packet = (PktBuf) malloc(sizeof(struct pbuf));
	    if (packet == NULL)
	      {
	        if (InternetDebug)
		  {
		    printf("malloc returned NULL.\n");
		  }
	        break;
	      }
	    packet->next = PacketFreeList;
	    PacketFreeList = packet;
	    FreeBufferCount += 1;
	    TotalBufferCount += 1;
	  }
        if (PacketFreeList == NULL)
	  {
	    if (InternetDebug)
	      {
		printf("RAN OUT OF PACKET BUFFERS!\n");
	      }
	    ReleaseGlobalSpinLock(BufferLock);
	    return(NULL);
	  }
      }
    NumAllocCalls += 1;
    FreeBufferCount -= 1;
    packet = PacketFreeList;
    PacketFreeList = PacketFreeList->next;
    ReleaseGlobalSpinLock(BufferLock);
    packet->length = 0;
    packet->next = NULL;
    packet->unspecified[3] = 0;
    packet->dataptr = packet->data;
    return(packet);
  }



/*
 * DeallocBuf:
 * Deallocate a buffer.
 */

DeallocBuf(pkt)
    PktBuf pkt;
  {

    /* BufSanityCheck(); */

    AcquireGlobalSpinLock(BufferLock);
    NumDeallocCalls += 1;
    FreeBufferCount += 1;
    pkt->next = PacketFreeList;
    PacketFreeList = pkt;
    ReleaseGlobalSpinLock(BufferLock);
  }



/*
 * ReturnBuf:
 * Return a packet buffer to free memory.
 */

ReturnBuf()
  {
    PktBuf packet;

    packet = AllocBuf();
    if (packet != NULL)
      {
	free(packet);
	TotalBufferCount -= 1;
	NumDeallocCalls += 1;
      }
  }
