/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * General include file for V shell.
 * Marvin Theimer.
 *
 * Marvin Theimer, 8/83
 *	File first created.
 */

# define FALSE 0
# define TRUE 1

# define MaxArgs 512		/* Maximum number of arguments on a command 
				   line. */
# define LineLength 512 	/* Max size of input line. */

# define ExpandBufLength 2048	/* Size of buffer for star expansion */

/*
 * History mechanism definitions.
 */

#define MaxHistCmds 20		/* Maximum number of commands remembered
				   in history. */


typedef struct HistoryRecType
  {
    char *cmds[MaxHistCmds];	/* Ptrs to last MaxHistCmds commands. */
    int nextCmd;		/* Next slot in cmds in which to place a
				   new command. */
    int nextCmdnum;		/* Next command number to be performed*/
				/* (initially 1) */
  } HistoryRec;


/*
 * Alias mechanism definitions
 */

#define MaxAliases 64		/* Maximum number of aliases remembered. */


typedef struct AliasRecType		/* Alias defn. record. */
  {
    char *alias;		/* Alias */
    char *cmd;			/* Cmd for which the alias stands. */
  } AliasRec;


/*
 * Input line-editting definitions
 */

typedef struct LineRecType
  {
    char *line;			/* Global ptr to current input line. */
    int lineLength;		/* Maximum allowed length of input line. */
    int endLine;		/* Index of end of input line. */
    int printChars;		/* Indicates whether output should be 
				   displayed. */
    int cursor;			/* Index of location of cursor. */
    File *in;			/* Input file from which to get input. */
    File *out;			/* Output file on which to display things. */
    int escFlag;		/* True if next char. should be ESC'd. */
  } LineRec;


/******** execserver material, added by Kenneth Brooks, December 1983 ********/

/* size of an executive's stack */
#define MainSize \
	(2 * (0x2000+ExpandBufLength+(6 * MaxArgs)+(2 * LineLength)))

#define EXEC_HOLD1	0x10	/* HOLD state with "errwithout" flag */

/* BlockSize must be as big as the biggest block size wanted by any server
 * on the system.  I hope this is it.
 */
#define BlockSize 1024
#define MAX_CONTEXT_NAME 128

struct ExecDescriptor
  {
  	/*
	 * this structure is allocated for each Executive,
	 * and gives the details for each one.  The reason why i/o buffers
	 * and the PerProcessArea are allocated here instead of in the usual
	 * fashion is so that we can free the whole business at one shot
	 * and avoid losing memory when an exec is deleted.
	 */
    ProcessId execPid;		/* pid of exec if any */
    ProcessId programPid;	/* program being executed if any */
    short status;		/* free, loading, or running */
    short ioflags;
    File in, out, err;		/* Files used by the exec */
    unsigned char inbuffer[BlockSize]; 
    unsigned char outbuffer[BlockSize];
    unsigned char errbuffer[BlockSize];	/* buffers used by the files */
    PerProcessArea perProcess;	/* per-process area, must immediately
    				 * precede stack */
    char stack[MainSize];	/* stack for the exec */
  };

typedef struct DirListEntry { struct DirListEntry *link; char *fn } DirList;

typedef struct PtrRecType {
                            char *expandPtr,**argv,*expandBuf;
			    int argc;
			  } PtrRec;

#define ARBITRARY_REMOTE_HOST_DESIGNATOR "any"
