#include <Vioprotocol.h>
#include <Vdirectory.h>
#include "sh.h"

extern char *malloc(), *DescriptorName();

DirList *ReadDirectory(path)
char *path;
/*
 * Return a sorted linked list of the names of the entries
 * in the directory 'path'.
 */
  {
    register DirList *entrylist, *e1;
    register File *dir;
    register char *n;
    ArbitraryDescriptor desc;
    SystemCode error; 
   
    entrylist = 0;
    dir = Open(path, FREAD|FDIRECTORY|FBLOCK_MODE, &error);
    if (!error)
      {
        for (dir->block = 0; dir->lastexception == OK; dir->block++)
          {
            if (Read(dir, &desc, dir->blocksize) != dir->blocksize)
              {
                if (dir->lastexception == END_OF_FILE) break;
                FreeDirList(entrylist);
                fprintf(stderr, "Error reading directory '%s'.\n", path);
                return(0);
              }
            if (!(n = DescriptorName(&desc))) continue;
            e1 = (DirList *) malloc(sizeof(DirList));
            e1->link = 0;
	    e1->fn = malloc(strlen(n)+1);
	    strcpy(e1->fn, n);
            if (!entrylist)
                entrylist = e1;
	    else
                InsertDirListEntry(entrylist, e1);
           }
        Close(dir);
      }
    return(entrylist);
  }

FreeDirList(head)
register DirList *head;
  {
    register DirList *p;

    p = head;
    while (head)
      {
        p = head->link;
        free(head);
        head = p;
      }
  }

InsertDirListEntry(head, rec)
register DirList *head, *rec;
  {
    register DirList *next;
    register char *s;

    next = head;
    while (next)
      {
        if (strcmp(rec->fn, next->fn) < 1)
          {
	    rec->link = next->link;
	    next->link = rec;
	    s = rec->fn;
	    rec->fn = next->fn;
	    next->fn = s;
	    next = 0;
	  }
	else if (!next->link)
	  {
	    next->link = rec;
	    next=0;
	  }
        else next=next->link;
      }
  }

